package com.amity.socialcloud.sdk.infra.mqtt.listener

import com.amity.socialcloud.sdk.api.core.AmityCoreClient
import com.amity.socialcloud.sdk.dto.video.StreamBanListDto
import com.amity.socialcloud.sdk.video.domain.stream.StreamIsBannedUseCase
import io.reactivex.rxjava3.schedulers.Schedulers


internal class StreamViewerDidBan : StreamBanEventListener() {

    override fun getEventName(): String {
        return "video-streaming.viewerDidBan"
    }

    override fun processEvent(dto: StreamBanListDto) {
        dto.list
            .firstOrNull { it.userId == AmityCoreClient.getUserId() }
            ?.streamId
            ?.let(StreamIsBannedUseCase()::execute)
            ?.subscribeOn(Schedulers.io())
            ?.subscribe()
    }

}