package com.amity.socialcloud.sdk.helper.core.metadata

import com.amity.socialcloud.sdk.helper.core.hashtag.AmityHashtag
import com.amity.socialcloud.sdk.helper.core.mention.AmityMentionMetadata
import com.google.gson.Gson
import com.google.gson.JsonObject

class AmityPostMetadataCreator constructor(
    private val hashtags: List<AmityHashtag>?,
    private val mentionMetaData: List<AmityMentionMetadata>?,
) {
    fun create(): JsonObject {
        val metadata = JsonObject()
        if (mentionMetaData?.isNotEmpty() == true) {
            metadata.add("mentioned", Gson().toJsonTree(mentionMetaData))
        }
        if (hashtags?.isNotEmpty() == true) {
            metadata.add("hashtags", Gson().toJsonTree(hashtags))
        }
        return metadata
    }
}
