package com.amity.socialcloud.sdk.dto.video

import com.ekoapp.ekosdk.internal.api.dto.EkoObjectDto
import com.google.gson.JsonArray
import com.google.gson.JsonObject
import com.google.gson.annotations.SerializedName
import org.joda.time.DateTime

// Skeleton DTO for Room item
data class RoomDto(
    @SerializedName("roomId") val roomId: String? = null,
    @SerializedName("type") val type: String? = null,
    @SerializedName("targetType") val targetType: String? = null,
    @SerializedName("targetId") val targetId: String? = null,
    @SerializedName("referenceType") val referenceType: String? = null,
    @SerializedName("referenceId") val referenceId: String? = null,
    @SerializedName("liveChatEnabled") val liveChatEnabled: Boolean? = null,
    @SerializedName("liveChannelId") val liveChannelId: String? = null,
    @SerializedName("title") val title: String? = null,
    @SerializedName("description") val description: String? = null,
    @SerializedName("thumbnailFileId") val thumbnailFileId: String? = null,
    @SerializedName("status") val status: String? = null,
    @SerializedName("participants") val participants: JsonArray? = null,
    @SerializedName("moderation") val moderation: JsonObject? = null,
    @SerializedName("livePlaybackUrl") val livePlaybackUrl: String? = null,
    @SerializedName("durationSeconds") val durationSeconds: Int? = null,
    @SerializedName("parentRoomId") val parentRoomId: String? = null,
    @SerializedName("childRoomIds") val childRoomIds: List<String>? = emptyList(),
    @SerializedName("createdBy") val createdBy: String? = null,
    @SerializedName("liveAt") val liveAt: DateTime? = null,
    @SerializedName("endedAt") val endedAt: DateTime? = null,
    @SerializedName("recordedAt") val recordedAt: DateTime? = null,
    @SerializedName("isDeleted") val isDeleted: Boolean = false,
    @SerializedName("deletedAt") val deletedAt: DateTime? = null,
    @SerializedName("deletedBy") val deletedBy: String? = null,
    @SerializedName("metadata") val metadata: JsonObject? = null,
    @SerializedName("recordedPlaybackInfos") val recordedPlaybackInfos: List<RoomRecordedPlaybackInfosDto>? = emptyList(),
    @SerializedName("path") val path: String? = null,

    ) : EkoObjectDto()

