package com.amity.socialcloud.sdk.core.data.presence.viewer

import com.amity.socialcloud.sdk.common.EntityMapper
import com.ekoapp.ekosdk.internal.api.dto.UserPresenceDto
import com.ekoapp.ekosdk.internal.api.dto.ViewerPresenceDto
import com.ekoapp.ekosdk.internal.entity.UserPresenceEntity

internal class ViewerPresenceEntityMapper : EntityMapper<ViewerPresenceDto, UserPresenceEntity>() {

    override fun map(list: List<ViewerPresenceDto>): List<UserPresenceEntity> {
        return list.map {
            UserPresenceEntity(
                userId = it.userId ?: "",
                lastHeartbeat = it.joinedAt
            )
        }
    }
}