package com.amity.socialcloud.sdk.api.video.room.query

import androidx.paging.PagingData
import com.amity.socialcloud.sdk.model.video.room.AmityRoom
import com.amity.socialcloud.sdk.model.video.room.AmityRoomSortOption
import com.amity.socialcloud.sdk.model.video.room.AmityRoomStatus
import com.amity.socialcloud.sdk.model.video.room.AmityRoomType
import com.amity.socialcloud.sdk.video.domain.room.RoomQueryPagingDataUseCase
import io.reactivex.rxjava3.core.Flowable

class AmityRoomQuery internal constructor(
    private val statuses: Array<AmityRoomStatus>?,
    private val types: Array<AmityRoomType>?,
    private val isDeleted: Boolean?,
    private val sortBy: AmityRoomSortOption?
) {
    fun query(): Flowable<PagingData<AmityRoom>> =
        RoomQueryPagingDataUseCase().execute(statuses, types, isDeleted, sortBy)

    class Builder internal constructor() {
        private var statuses: Array<AmityRoomStatus>? = null
        private var types: Array<AmityRoomType>? = null
        private var isDeleted: Boolean? = null
        private var sortBy: AmityRoomSortOption? = null

        fun setStatuses(statuses: Array<AmityRoomStatus>) = apply { this.statuses = statuses }
        fun setTypes(types: Array<AmityRoomType>) = apply { this.types = types }
        fun setIsDeleted(isDeleted: Boolean?) = apply { this.isDeleted = isDeleted }
        fun setSortBy(sortBy: AmityRoomSortOption?) = apply { this.sortBy = sortBy }
        fun build(): AmityRoomQuery = AmityRoomQuery(statuses, types, isDeleted, sortBy)
    }
}

