package com.amity.socialcloud.sdk.core.domain.notificationtray.composer

import com.amity.socialcloud.sdk.core.domain.ComposerUseCase
import com.amity.socialcloud.sdk.core.domain.user.UserGetUseCase
import com.amity.socialcloud.sdk.model.core.notificationtray.AmityNotificationTrayItem
import com.amity.socialcloud.sdk.social.domain.event.EventGetUseCase

internal class NotificationTrayComposerUseCase : ComposerUseCase() {
    fun execute(notiTrayItem: AmityNotificationTrayItem): AmityNotificationTrayItem {
        addActorUser(notiTrayItem)
        addEvent(notiTrayItem)
        return notiTrayItem
    }

    private fun addActorUser(notiTrayItem: AmityNotificationTrayItem) {
        val userList = notiTrayItem.getActors()?.mapNotNull { UserGetUseCase().execute(it.getPublicId()) }
        notiTrayItem.actorUsers = userList
    }

    private fun addEvent(notiTrayItem: AmityNotificationTrayItem) {
        if (notiTrayItem.getActionType() == "event") {
            val eventId = notiTrayItem.getActionReferenceId()
            if (eventId.isNotEmpty()) {
                val event = EventGetUseCase().execute(eventId)
                notiTrayItem.event = event
            }
        }
    }

}