package com.amity.socialcloud.sdk.social.data.event

import com.amity.socialcloud.sdk.core.data.file.FileEntityMapper
import com.amity.socialcloud.sdk.core.data.file.FileLocalDataStore
import com.amity.socialcloud.sdk.core.data.user.UserEntityMapper
import com.amity.socialcloud.sdk.core.data.user.UserLocalDataStore
import com.amity.socialcloud.sdk.core.data.user.flag.UserFlagEntityMapper
import com.amity.socialcloud.sdk.core.data.user.flag.UserFlagLocalDataStore
import com.amity.socialcloud.sdk.social.data.community.CommunityEntityMapper
import com.amity.socialcloud.sdk.social.data.community.CommunityLocalDataStore
import com.amity.socialcloud.sdk.social.data.community.DiscussionCommunityEntityMapper
import com.amity.socialcloud.sdk.social.data.community.DiscussionCommunityLocalDataStore
import com.amity.socialcloud.sdk.video.data.stream.StreamEntityMapper
import com.amity.socialcloud.sdk.video.data.stream.StreamLocalDataStore
import com.ekoapp.ekosdk.internal.api.dto.EventListDto
import io.reactivex.rxjava3.core.Completable

internal class EventQueryPersister {

    fun persist(dto: EventListDto): Completable {
        return Completable.defer {
            val fileCompletable = if (dto.files.isNotEmpty()) {
                FileLocalDataStore().saveFiles(FileEntityMapper().map(dto.files))
            } else {
                Completable.complete()
            }
            
            val userCompletable = if (dto.users.isNotEmpty()) {
                UserLocalDataStore().saveUsers(UserEntityMapper().map(dto.users))
            } else {
                Completable.complete()
            }
            
            val userFlagCompletable = if (dto.users.isNotEmpty()) {
                UserFlagLocalDataStore().saveFlags(UserFlagEntityMapper().map(dto.users))
            } else {
                Completable.complete()
            }
            
            val eventCompletable = dto.events?.let { events ->
                val entities = EventEntityMapper().map(events)
                EventLocalDataStore().saveEvents(entities)
            } ?: Completable.complete()
            
            val communityCompletable = if (dto.communities.isNotEmpty()) {
                val communityEntities = CommunityEntityMapper().map(dto.communities)
                CommunityLocalDataStore().saveCommunities(communityEntities)
            } else {
                Completable.complete()
            }
            
            val discussionCommunityCompletable = if (dto.discussionCommunities.isNotEmpty()) {
                val discussionCommunityEntities = DiscussionCommunityEntityMapper().map(dto.discussionCommunities)
                DiscussionCommunityLocalDataStore().saveDiscussionCommunities(discussionCommunityEntities)
            } else {
                Completable.complete()
            }
            
            val streamCompletable = if (dto.videoStreamings.isNotEmpty()) {
                StreamLocalDataStore().saveStream(StreamEntityMapper().map(dto.videoStreamings))
            } else {
                Completable.complete()
            }
            
            Completable.mergeArray(
                fileCompletable,
                userCompletable,
                userFlagCompletable,
                eventCompletable,
                communityCompletable,
                discussionCommunityCompletable,
                streamCompletable
            )
        }
    }
}
