package com.amity.socialcloud.sdk.social.data.event

import com.ekoapp.ekosdk.internal.api.dto.EkoDeletionDto
import com.ekoapp.ekosdk.internal.api.dto.EventListDto
import com.ekoapp.ekosdk.internal.api.socket.request.EventCreateRequest
import com.ekoapp.ekosdk.internal.api.socket.request.EventUpdateRequest
import io.reactivex.rxjava3.core.Single
import retrofit2.http.Body
import retrofit2.http.DELETE
import retrofit2.http.GET
import retrofit2.http.POST
import retrofit2.http.PUT
import retrofit2.http.Path
import retrofit2.http.Query

interface EventApi {

    @GET("api/v1/events/{eventId}")
    fun getEvent(@Path("eventId") eventId: String): Single<EventListDto>

    @GET("api/v1/events")
    fun queryEvents(
        @Query("originType") originType: String?,
        @Query("originId") originId: String?,
        @Query("userId") userId: String?,
        @Query("status") status: String?,
        @Query("type") type: String?,
        @Query("options[limit]") limit: Int?,
        @Query("options[token]") token: String?
    ): Single<EventListDto>

    @GET("api/v1/events/me/rsvps")
    fun getMyEvents(
        @Query("status") status: String?,
        @Query("options[limit]") limit: Int?,
        @Query("options[token]") token: String?
    ): Single<EventListDto>

    @POST("api/v1/events")
    fun createEvent(@Body request: EventCreateRequest): Single<EventListDto>

    @PUT("api/v1/events/{eventId}")
    fun updateEvent(
        @Path("eventId") eventId: String,
        @Body request: EventUpdateRequest
    ): Single<EventListDto>

    @DELETE("api/v1/events/{eventId}")
    fun deleteEvent(@Path("eventId") eventId: String): Single<EkoDeletionDto>
}
