package com.amity.socialcloud.sdk.social.data.community

import com.amity.socialcloud.sdk.common.ModelMapper
import com.amity.socialcloud.sdk.model.social.community.AmityDiscussionCommunity
import com.ekoapp.ekosdk.internal.entity.DiscussionCommunityEntity

internal class DiscussionCommunityModelMapper : ModelMapper<DiscussionCommunityEntity, AmityDiscussionCommunity>() {

    override fun map(entity: DiscussionCommunityEntity): AmityDiscussionCommunity {
        return entity.run {
            AmityDiscussionCommunity(
                communityId = communityId,
                channelId = channelId ?: "",
                userId = userId ?: "",
                displayName = displayName ?: "",
                description = description ?: "",
                avatarFileId = avatarFileId ?: "",
                isOfficial = isOfficial ?: false,
                isPublic = isPublic ?: false,
                onlyAdminCanPost = onlyAdminCanPost ?: false,
                allowCommentInStory = allowCommentInStory ?: false,
                tags = getTags(),
                metadata = metadata,
                postsCount = postsCount ?: 0,
                membersCount = membersCount ?: 0,
                isJoined = isJoined ?: false,
                isDeleted = isDeleted ?: false,
                categoryIds = categoryIds,
                categories = emptyList(),
                user = null,
                avatarImage = null,
                isPostReviewEnabled = needApprovalOnPostCreation ?: false,
                createdAt = createdAt,
                updatedAt = updatedAt,
                path = path,
                isDiscoverable = isDiscoverable ?: false,
                requiresJoinApproval = requiresJoinApproval ?: false,
            )
        }
    }
}
