package com.amity.socialcloud.sdk.core.domain.topic

import com.amity.socialcloud.sdk.model.core.events.AmityRoomEvents
import com.amity.socialcloud.sdk.model.video.room.AmityRoom
import io.reactivex.rxjava3.core.Single

internal class RoomTopicGeneratorUseCase : TopicGenerationUseCase() {

    fun execute(room: AmityRoom, events: AmityRoomEvents): Single<String> {
        val topic = when (events) {
            AmityRoomEvents.VIEWER -> {
                room.path
            }
            AmityRoomEvents.STREAMER -> {
                room.path + "/streamer/+"
            }
        }
        return Single.just(topic)
    }
}