/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal;

import androidx.room.Entity;
import androidx.room.Index;
import androidx.room.PrimaryKey;
import com.amity.socialcloud.sdk.model.chat.message.AmityMessage;
import com.amity.socialcloud.sdk.model.core.reaction.AmityReactionMap;
import com.amity.socialcloud.sdk.model.core.tag.AmityTags;
import com.ekoapp.ekosdk.EkoObject;
import com.ekoapp.ekosdk.TaggedEkoObject;
import com.ekoapp.ekosdk.internal.api.dto.EkoMentioneesDto;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.amity.types.ObjectId;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0014\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\\\u001a\u00020\u0006H\u0016J\b\u0010]\u001a\u000200H\u0016J\u000e\u0010^\u001a\u00020_2\u0006\u0010/\u001a\u000200J\u0006\u0010`\u001a\u00020\u001bJ\u000e\u0010a\u001a\u00020_2\u0006\u0010b\u001a\u00020\u001bJ\u0006\u0010c\u001a\u00020dJ\u000e\u0010e\u001a\u00020_2\u0006\u0010f\u001a\u00020gJ\u0013\u0010h\u001a\u00020(2\b\u0010i\u001a\u0004\u0018\u00010jH\u0096\u0002J\b\u0010k\u001a\u00020\u001bH\u0016J\u0010\u0010l\u001a\u00020\u00062\u0006\u0010m\u001a\u00020nH\u0014R\u001e\u0010\u0005\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\b\"\u0004\b\r\u0010\nR\u001a\u0010\u000e\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\b\"\u0004\b\u0010\u0010\nR\u001a\u0010\u0011\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\b\"\u0004\b\u0013\u0010\nR\u001a\u0010\u0014\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\b\"\u0004\b\u0016\u0010\nR\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\b\"\u0004\b\u0019\u0010\nR\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001c\u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001a\u0010'\u001a\u00020(X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010)\"\u0004\b*\u0010+R\u001a\u0010,\u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010\u001e\"\u0004\b.\u0010 R\u000e\u0010/\u001a\u000200X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u00101\u001a\u000202X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u00104\"\u0004\b5\u00106R\u001a\u00107\u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u0010\u001e\"\u0004\b9\u0010 R\u001a\u0010:\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u0010\b\"\u0004\b<\u0010\nR\u001c\u0010=\u001a\u0004\u0018\u00010>X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b?\u0010@\"\u0004\bA\u0010BR\u001c\u0010C\u001a\u0004\u0018\u00010>X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bD\u0010@\"\u0004\bE\u0010BR \u0010F\u001a\b\u0012\u0004\u0012\u00020H0GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bI\u0010J\"\u0004\bK\u0010LR\u001c\u0010M\u001a\u0004\u0018\u00010NX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bO\u0010P\"\u0004\bQ\u0010RR\u001a\u0010S\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bT\u0010\b\"\u0004\bU\u0010\nR\u001a\u0010V\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bW\u0010\b\"\u0004\bX\u0010\nR\u001a\u0010Y\u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bZ\u0010\u001e\"\u0004\b[\u0010 \u00a8\u0006o"}, d2={"Lcom/ekoapp/ekosdk/internal/EkoMessageEntity;", "Lcom/ekoapp/ekosdk/EkoObject;", "Lcom/ekoapp/ekosdk/TaggedEkoObject;", "<init>", "()V", "uniqueId", "", "getUniqueId", "()Ljava/lang/String;", "setUniqueId", "(Ljava/lang/String;)V", "messageId", "getMessageId", "setMessageId", "subChannelId", "getSubChannelId", "setSubChannelId", "channelId", "getChannelId", "setChannelId", "userId", "getUserId", "setUserId", "parentId", "getParentId", "setParentId", "channelSegment", "", "childrenNumber", "getChildrenNumber", "()I", "setChildrenNumber", "(I)V", "editedAt", "Lorg/joda/time/DateTime;", "getEditedAt", "()Lorg/joda/time/DateTime;", "setEditedAt", "(Lorg/joda/time/DateTime;)V", "isDeleted", "", "()Z", "setDeleted", "(Z)V", "flagCount", "getFlagCount", "setFlagCount", "tags", "Lcom/amity/socialcloud/sdk/model/core/tag/AmityTags;", "reactions", "Lcom/amity/socialcloud/sdk/model/core/reaction/AmityReactionMap;", "getReactions", "()Lcom/amity/socialcloud/sdk/model/core/reaction/AmityReactionMap;", "setReactions", "(Lcom/amity/socialcloud/sdk/model/core/reaction/AmityReactionMap;)V", "reactionCount", "getReactionCount", "setReactionCount", "type", "getType", "setType", "data", "Lcom/google/gson/JsonObject;", "getData", "()Lcom/google/gson/JsonObject;", "setData", "(Lcom/google/gson/JsonObject;)V", "metadata", "getMetadata", "setMetadata", "mentionees", "", "Lcom/ekoapp/ekosdk/internal/api/dto/EkoMentioneesDto;", "getMentionees", "()Ljava/util/List;", "setMentionees", "(Ljava/util/List;)V", "pii", "Lcom/google/gson/JsonArray;", "getPii", "()Lcom/google/gson/JsonArray;", "setPii", "(Lcom/google/gson/JsonArray;)V", "path", "getPath", "setPath", "syncState", "getSyncState", "setSyncState", "messageMarkerHash", "getMessageMarkerHash", "setMessageMarkerHash", "getId", "getTags", "setTags", "", "getChannelSegment", "setChannelSegment", "segment", "getDataType", "Lcom/amity/socialcloud/sdk/model/chat/message/AmityMessage$DataType;", "setState", "state", "Lcom/amity/socialcloud/sdk/model/chat/message/AmityMessage$State;", "equals", "obj", "", "hashCode", "internalToString", "toStringHelper", "Lcom/google/common/base/MoreObjects$ToStringHelper;", "amity-sdk_release"})
@Entity(tableName="message", indices={@Index(value={"subChannelId"}), @Index(value={"syncState"}), @Index(value={"subChannelId", "createdAt"}), @Index(value={"subChannelId", "channelSegment"})})
public class EkoMessageEntity
extends EkoObject
implements TaggedEkoObject {
    @PrimaryKey
    @NotNull
    private String uniqueId = "LOCAL" + ObjectId.Companion.get().toHexString();
    @NotNull
    private String messageId = ObjectId.Companion.get().toHexString();
    @NotNull
    private String subChannelId = "";
    @NotNull
    private String channelId = "";
    @NotNull
    private String userId = "";
    @Nullable
    private String parentId;
    private int channelSegment;
    private int childrenNumber;
    @NotNull
    private DateTime editedAt;
    private boolean isDeleted;
    private int flagCount;
    @NotNull
    private AmityTags tags;
    @NotNull
    private AmityReactionMap reactions;
    private int reactionCount;
    @NotNull
    private String type;
    @Nullable
    private JsonObject data;
    @Nullable
    private JsonObject metadata;
    @NotNull
    private List<EkoMentioneesDto> mentionees;
    @Nullable
    private JsonArray pii;
    @NotNull
    private String path;
    @NotNull
    private String syncState;
    private int messageMarkerHash;

    public EkoMessageEntity() {
        DateTime dateTime = DateTime.now();
        Intrinsics.checkNotNullExpressionValue((Object)dateTime, (String)"now(...)");
        this.editedAt = dateTime;
        this.tags = new AmityTags();
        this.reactions = new AmityReactionMap();
        this.type = AmityMessage.DataType.CUSTOM.getApiKey();
        this.mentionees = CollectionsKt.emptyList();
        this.path = "";
        this.syncState = AmityMessage.State.SYNCED.getStateName();
    }

    @NotNull
    public final String getUniqueId() {
        return this.uniqueId;
    }

    public final void setUniqueId(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.uniqueId = string;
    }

    @NotNull
    public final String getMessageId() {
        return this.messageId;
    }

    public final void setMessageId(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.messageId = string;
    }

    @NotNull
    public final String getSubChannelId() {
        return this.subChannelId;
    }

    public final void setSubChannelId(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.subChannelId = string;
    }

    @NotNull
    public final String getChannelId() {
        return this.channelId;
    }

    public final void setChannelId(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.channelId = string;
    }

    @NotNull
    public final String getUserId() {
        return this.userId;
    }

    public final void setUserId(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.userId = string;
    }

    @Nullable
    public final String getParentId() {
        return this.parentId;
    }

    public final void setParentId(@Nullable String string) {
        this.parentId = string;
    }

    public final int getChildrenNumber() {
        return this.childrenNumber;
    }

    public final void setChildrenNumber(int n) {
        this.childrenNumber = n;
    }

    @NotNull
    public final DateTime getEditedAt() {
        return this.editedAt;
    }

    public final void setEditedAt(@NotNull DateTime dateTime) {
        Intrinsics.checkNotNullParameter((Object)dateTime, (String)"<set-?>");
        this.editedAt = dateTime;
    }

    public final boolean isDeleted() {
        return this.isDeleted;
    }

    public final void setDeleted(boolean bl) {
        this.isDeleted = bl;
    }

    public final int getFlagCount() {
        return this.flagCount;
    }

    public final void setFlagCount(int n) {
        this.flagCount = n;
    }

    @NotNull
    public final AmityReactionMap getReactions() {
        return this.reactions;
    }

    public final void setReactions(@NotNull AmityReactionMap amityReactionMap) {
        Intrinsics.checkNotNullParameter((Object)amityReactionMap, (String)"<set-?>");
        this.reactions = amityReactionMap;
    }

    public final int getReactionCount() {
        return this.reactionCount;
    }

    public final void setReactionCount(int n) {
        this.reactionCount = n;
    }

    @NotNull
    public final String getType() {
        return this.type;
    }

    public final void setType(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.type = string;
    }

    @Nullable
    public final JsonObject getData() {
        return this.data;
    }

    public final void setData(@Nullable JsonObject jsonObject) {
        this.data = jsonObject;
    }

    @Nullable
    public final JsonObject getMetadata() {
        return this.metadata;
    }

    public final void setMetadata(@Nullable JsonObject jsonObject) {
        this.metadata = jsonObject;
    }

    @NotNull
    public final List<EkoMentioneesDto> getMentionees() {
        return this.mentionees;
    }

    public final void setMentionees(@NotNull List<EkoMentioneesDto> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.mentionees = list;
    }

    @Nullable
    public final JsonArray getPii() {
        return this.pii;
    }

    public final void setPii(@Nullable JsonArray jsonArray) {
        this.pii = jsonArray;
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    public final void setPath(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.path = string;
    }

    @NotNull
    public final String getSyncState() {
        return this.syncState;
    }

    public final void setSyncState(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.syncState = string;
    }

    public final int getMessageMarkerHash() {
        return this.messageMarkerHash;
    }

    public final void setMessageMarkerHash(int n) {
        this.messageMarkerHash = n;
    }

    @Override
    @NotNull
    public String getId() {
        return this.uniqueId;
    }

    @Override
    @NotNull
    public AmityTags getTags() {
        return this.tags;
    }

    public final void setTags(@NotNull AmityTags tags) {
        Intrinsics.checkNotNullParameter((Object)tags, (String)"tags");
        this.tags = tags;
    }

    public final int getChannelSegment() {
        return this.channelSegment;
    }

    public final void setChannelSegment(int segment) {
        this.channelSegment = Math.max(this.channelSegment, segment);
    }

    @NotNull
    public final AmityMessage.DataType getDataType() {
        return AmityMessage.DataType.Companion.enumOf(this.type);
    }

    public final void setState(@NotNull AmityMessage.State state) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        this.syncState = state.getStateName();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object obj) {
        if (!super.equals(obj)) return false;
        Intrinsics.checkNotNull((Object)obj, (String)"null cannot be cast to non-null type com.ekoapp.ekosdk.internal.EkoMessageEntity");
        if (!Objects.equal((Object)this.messageId, (Object)((EkoMessageEntity)obj).messageId)) return false;
        if (!Objects.equal((Object)this.uniqueId, (Object)((EkoMessageEntity)obj).messageId)) return false;
        if (!Objects.equal((Object)this.subChannelId, (Object)((EkoMessageEntity)obj).subChannelId)) return false;
        if (!Objects.equal((Object)this.channelId, (Object)((EkoMessageEntity)obj).channelId)) return false;
        if (!Objects.equal((Object)this.userId, (Object)((EkoMessageEntity)obj).userId)) return false;
        if (!Objects.equal((Object)this.parentId, (Object)((EkoMessageEntity)obj).parentId)) return false;
        if (!Objects.equal((Object)this.channelSegment, (Object)((EkoMessageEntity)obj).channelSegment)) return false;
        if (!Objects.equal((Object)this.childrenNumber, (Object)((EkoMessageEntity)obj).childrenNumber)) return false;
        if (!Objects.equal((Object)this.editedAt, (Object)((EkoMessageEntity)obj).editedAt)) return false;
        if (!Objects.equal((Object)this.isDeleted, (Object)((EkoMessageEntity)obj).isDeleted)) return false;
        if (!Objects.equal((Object)this.flagCount, (Object)((EkoMessageEntity)obj).flagCount)) return false;
        if (!Objects.equal((Object)this.tags, (Object)((EkoMessageEntity)obj).tags)) return false;
        if (!Objects.equal((Object)this.reactions, (Object)((EkoMessageEntity)obj).reactions)) return false;
        if (!Objects.equal((Object)this.reactionCount, (Object)((EkoMessageEntity)obj).reactionCount)) return false;
        if (!Objects.equal((Object)this.type, (Object)((EkoMessageEntity)obj).type)) return false;
        if (!Objects.equal((Object)this.data, (Object)((EkoMessageEntity)obj).data)) return false;
        if (!Objects.equal((Object)this.syncState, (Object)((EkoMessageEntity)obj).syncState)) return false;
        if (!Objects.equal((Object)this.metadata, (Object)((EkoMessageEntity)obj).metadata)) return false;
        if (!Objects.equal(this.mentionees, ((EkoMessageEntity)obj).mentionees)) return false;
        if (!Objects.equal((Object)this.pii, (Object)((EkoMessageEntity)obj).pii)) return false;
        return true;
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{super.hashCode(), this.uniqueId, this.messageId, this.subChannelId, this.channelId, this.userId, this.parentId, this.channelSegment, this.childrenNumber, this.editedAt, this.isDeleted, this.flagCount, this.tags, this.reactions, this.reactionCount, this.syncState, this.type, this.data, this.metadata, this.mentionees, this.pii};
        return Objects.hashCode((Object[])objectArray);
    }

    @Override
    @NotNull
    protected String internalToString(@NotNull MoreObjects.ToStringHelper toStringHelper) {
        Intrinsics.checkNotNullParameter((Object)toStringHelper, (String)"toStringHelper");
        toStringHelper.add("uniqueId", (Object)this.uniqueId).add("messageId", (Object)this.messageId).add("subChannelId", (Object)this.subChannelId).add("channelId", (Object)this.channelId).add("userId", (Object)this.userId).add("parentId", (Object)this.parentId).add("segment", this.channelSegment).add("childrenNumber", this.childrenNumber).add("editedAt", (Object)this.editedAt).add("isDeleted", this.isDeleted).add("flagCount", this.flagCount).add("tags", (Object)this.tags).add("reactions", (Object)this.reactions).add("reactionCount", this.reactionCount).add("syncState", (Object)this.syncState).add("type", (Object)this.type).add("data", (Object)this.data).add("metadata", (Object)this.metadata).add("mentionees", this.mentionees).add("pii", (Object)this.pii);
        String string = super.internalToString(toStringHelper);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"internalToString(...)");
        return string;
    }
}

