/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.social.data.category;

import androidx.paging.PagingConfig;
import androidx.paging.PagingData;
import androidx.paging.PagingSource;
import co.amity.rxbridge.FlowableKt;
import com.amity.socialcloud.sdk.api.social.category.query.AmityCommunityCategorySortOption;
import com.amity.socialcloud.sdk.common.AmityObjectRepository;
import com.amity.socialcloud.sdk.common.ModelMapper;
import com.amity.socialcloud.sdk.entity.social.category.CommunityCategoryEntity;
import com.amity.socialcloud.sdk.model.social.category.AmityCommunityCategory;
import com.amity.socialcloud.sdk.social.data.category.CategoryLocalDataStore;
import com.amity.socialcloud.sdk.social.data.category.CategoryModelMapper;
import com.amity.socialcloud.sdk.social.data.category.CategoryRemoteDataStore;
import com.amity.socialcloud.sdk.social.data.category.CategoryRepository;
import com.amity.socialcloud.sdk.social.data.category.paging.CategoryMediator;
import com.ekoapp.ekosdk.internal.keycreator.DynamicQueryStreamKeyCreator;
import com.ekoapp.ekosdk.internal.paging.DynamicQueryStreamPagerCreator;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.functions.Function;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00022\u0006\u0010\b\u001a\u00020\tH\u0016J\u0014\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\fH\u0016J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u000e2\u0006\u0010\b\u001a\u00020\tH\u0016J\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\u0010J)\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00130\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017\u00a2\u0006\u0002\u0010\u0018J+\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00030\u000e2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\u0002\u0010\u001e\u00a8\u0006\u001f"}, d2={"Lcom/amity/socialcloud/sdk/social/data/category/CategoryRepository;", "Lcom/amity/socialcloud/sdk/common/AmityObjectRepository;", "Lcom/amity/socialcloud/sdk/entity/social/category/CommunityCategoryEntity;", "Lcom/amity/socialcloud/sdk/model/social/category/AmityCommunityCategory;", "<init>", "()V", "fetchAndSave", "Lio/reactivex/rxjava3/core/Completable;", "objectId", "", "queryFromCache", "mapper", "Lcom/amity/socialcloud/sdk/common/ModelMapper;", "observeFromCache", "Lio/reactivex/rxjava3/core/Flowable;", "getCategories", "", "categoryIds", "getAllCategoriesPagingData", "Landroidx/paging/PagingData;", "sortOption", "Lcom/amity/socialcloud/sdk/api/social/category/query/AmityCommunityCategorySortOption;", "isDeleted", "", "(Lcom/amity/socialcloud/sdk/api/social/category/query/AmityCommunityCategorySortOption;Ljava/lang/Boolean;)Lio/reactivex/rxjava3/core/Flowable;", "getLatestCategory", "dynamicQueryStreamKeyCreator", "Lcom/ekoapp/ekosdk/internal/keycreator/DynamicQueryStreamKeyCreator;", "nonce", "", "(Ljava/lang/Boolean;Lcom/ekoapp/ekosdk/internal/keycreator/DynamicQueryStreamKeyCreator;I)Lio/reactivex/rxjava3/core/Flowable;", "amity-sdk_release"})
@SourceDebugExtension(value={"SMAP\nCategoryRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CategoryRepository.kt\ncom/amity/socialcloud/sdk/social/data/category/CategoryRepository\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,89:1\n1563#2:90\n1634#2,3:91\n*S KotlinDebug\n*F\n+ 1 CategoryRepository.kt\ncom/amity/socialcloud/sdk/social/data/category/CategoryRepository\n*L\n45#1:90\n45#1:91,3\n*E\n"})
public final class CategoryRepository
extends AmityObjectRepository<CommunityCategoryEntity, AmityCommunityCategory> {
    @Override
    @NotNull
    public Completable fetchAndSave(@NotNull String objectId) {
        Intrinsics.checkNotNullParameter((Object)objectId, (String)"objectId");
        Completable completable = new CategoryRemoteDataStore().getCategory(objectId).flatMapCompletable((Function)fetchAndSave.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"flatMapCompletable(...)");
        return completable;
    }

    @Override
    @Nullable
    public CommunityCategoryEntity queryFromCache(@NotNull String objectId) {
        Intrinsics.checkNotNullParameter((Object)objectId, (String)"objectId");
        return new CategoryLocalDataStore().getCategory(objectId);
    }

    @Override
    @NotNull
    public ModelMapper<CommunityCategoryEntity, AmityCommunityCategory> mapper() {
        return new CategoryModelMapper();
    }

    @Override
    @NotNull
    public Flowable<CommunityCategoryEntity> observeFromCache(@NotNull String objectId) {
        Intrinsics.checkNotNullParameter((Object)objectId, (String)"objectId");
        return new CategoryLocalDataStore().observeCategory(objectId);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<AmityCommunityCategory> getCategories(@NotNull List<String> categoryIds) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(categoryIds, (String)"categoryIds");
        Iterable $this$map$iv = new CategoryLocalDataStore().getCategories(categoryIds);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            CommunityCategoryEntity communityCategoryEntity = (CommunityCategoryEntity)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new CategoryModelMapper().map((CommunityCategoryEntity)it));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final Flowable<PagingData<AmityCommunityCategory>> getAllCategoriesPagingData(@NotNull AmityCommunityCategorySortOption sortOption, @Nullable Boolean isDeleted) {
        Intrinsics.checkNotNullParameter((Object)((Object)sortOption), (String)"sortOption");
        DynamicQueryStreamPagerCreator pagerCreator = new DynamicQueryStreamPagerCreator(new PagingConfig(20, 0, true, 0, 0, 0, 58, null), null, new CategoryMediator(sortOption, isDeleted), () -> CategoryRepository.getAllCategoriesPagingData$lambda$1(sortOption, isDeleted), (ModelMapper)new CategoryModelMapper(), 2, null);
        return FlowableKt.toRx3(pagerCreator.create());
    }

    @NotNull
    public final Flowable<AmityCommunityCategory> getLatestCategory(@Nullable Boolean isDeleted, @NotNull DynamicQueryStreamKeyCreator dynamicQueryStreamKeyCreator, int nonce) {
        Intrinsics.checkNotNullParameter((Object)dynamicQueryStreamKeyCreator, (String)"dynamicQueryStreamKeyCreator");
        Flowable flowable = new CategoryLocalDataStore().getLatestCategory(isDeleted, dynamicQueryStreamKeyCreator, nonce).map((Function)getLatestCategory.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"map(...)");
        return flowable;
    }

    private static final PagingSource getAllCategoriesPagingData$lambda$1(AmityCommunityCategorySortOption $sortOption, Boolean $isDeleted) {
        return new CategoryLocalDataStore().getCategoryPagingSource($sortOption, $isDeleted);
    }
}

