/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.infra.upload;

import android.content.Context;
import android.net.Uri;
import co.amity.rxupload.FileProperties;
import co.amity.rxupload.extension.UriKt;
import com.amity.socialcloud.sdk.core.data.file.RawFileModelMapper;
import com.amity.socialcloud.sdk.infra.upload.AmityImageUploadService;
import com.amity.socialcloud.sdk.infra.upload.AmityUploadService;
import com.amity.socialcloud.sdk.model.core.error.AmityException;
import com.amity.socialcloud.sdk.model.core.file.AmityImage;
import com.amity.socialcloud.sdk.model.core.file.AmityRawFile;
import com.amity.socialcloud.sdk.model.core.file.upload.AmityUploadInfo;
import com.amity.socialcloud.sdk.model.core.file.upload.AmityUploadResult;
import com.ekoapp.ekosdk.EkoObject;
import com.ekoapp.ekosdk.internal.EkoFileEntity;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.dao.EkoFileDao;
import com.ekoapp.ekosdk.internal.util.AppContext;
import io.reactivex.rxjava3.android.schedulers.AndroidSchedulers;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.reactivestreams.Publisher;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001:\u0001\u0014B/\b\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0014\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J\u0014\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J\u0014\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0012H\u0014J\u001c\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u00122\u0006\u0010\u0004\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/amity/socialcloud/sdk/infra/upload/AmityImageUploadService;", "Lcom/amity/socialcloud/sdk/infra/upload/AmityUploadService;", "Lcom/amity/socialcloud/sdk/model/core/file/upload/AmityUploadResult;", "Lcom/amity/socialcloud/sdk/model/core/file/AmityImage;", "uri", "Landroid/net/Uri;", "uploadId", "", "isFullImage", "", "altText", "<init>", "(Landroid/net/Uri;Ljava/lang/String;ZLjava/lang/String;)V", "getUploadParams", "", "", "getUploadHeaders", "makeUploadServiceRequest", "Lio/reactivex/rxjava3/core/Flowable;", "uploadContentUri", "Builder", "amity-sdk_release"})
public final class AmityImageUploadService
extends AmityUploadService<AmityUploadResult<? extends AmityImage>> {
    @NotNull
    private final Uri uri;
    @Nullable
    private final String uploadId;
    private final boolean isFullImage;
    @Nullable
    private final String altText;

    private AmityImageUploadService(Uri uri, String uploadId, boolean isFullImage, String altText) {
        this.uri = uri;
        this.uploadId = uploadId;
        this.isFullImage = isFullImage;
        this.altText = altText;
    }

    /* synthetic */ AmityImageUploadService(Uri uri, String string, boolean bl, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            string2 = null;
        }
        this(uri, string, bl, string2);
    }

    @Override
    @NotNull
    public Map<String, Object> getUploadParams() {
        Map map;
        Map $this$getUploadParams_u24lambda_u240 = map = MapsKt.toMutableMap((Map)MapsKt.emptyMap());
        boolean bl = false;
        $this$getUploadParams_u24lambda_u240.put("accessType", this.getAccessType$amity_sdk_release().getApiKey());
        CharSequence charSequence = this.altText;
        if (!(charSequence == null || charSequence.length() == 0)) {
            $this$getUploadParams_u24lambda_u240.put("altText", this.altText);
        }
        return MapsKt.toMap((Map)map);
    }

    @Override
    @NotNull
    public Map<String, Object> getUploadHeaders() {
        return MapsKt.emptyMap();
    }

    @Override
    @NotNull
    protected Flowable<AmityUploadResult<AmityImage>> makeUploadServiceRequest() {
        return this.uploadContentUri(this.uri);
    }

    private final Flowable<AmityUploadResult<AmityImage>> uploadContentUri(Uri uri) {
        Context context = AppContext.get();
        Map<String, Object> map = this.getUploadParams();
        Map<String, Object> map2 = this.getUploadHeaders();
        String string = this.uploadId;
        String string2 = this.getAccessType$amity_sdk_release().getApiKey();
        Flowable flowable = UriKt.upload((Uri)uri, (Context)context, (String)"api/v4/images", map2, map, (String)string, (String)"file", (String)string2).flatMap(new Function(this){
            final /* synthetic */ AmityImageUploadService this$0;
            {
                this.this$0 = $receiver;
            }

            public final Publisher<? extends AmityUploadResult<AmityImage>> apply(FileProperties fileProps) {
                Flowable flowable;
                Intrinsics.checkNotNullParameter((Object)fileProps, (String)"fileProps");
                if (fileProps.getProgress() == 100) {
                    Flowable flowable2 = Single.fromCallable(() -> uploadContentUri.1.apply$lambda$0(this.this$0, fileProps)).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).flatMapPublisher((Function)uploadContentUri.2.INSTANCE);
                    Intrinsics.checkNotNull((Object)flowable2);
                    flowable = flowable2;
                } else {
                    Flowable flowable3 = Flowable.just((Object)new AmityUploadResult.PROGRESS(new AmityUploadInfo(fileProps)));
                    Intrinsics.checkNotNull((Object)flowable3);
                    flowable = flowable3;
                }
                return (Publisher)flowable;
            }

            private static final AmityRawFile apply$lambda$0(AmityImageUploadService this$0, FileProperties $fileProps) {
                EkoFileEntity fileEntity = this$0.parseEkoFileEntity($fileProps.getResponseBody());
                fileEntity.setFilePath($fileProps.getUri().getPath());
                EkoFileDao fileDao = UserDatabase.get().fileDao();
                fileDao.insert((EkoObject)fileEntity);
                return new RawFileModelMapper().map(fileEntity);
            }
        }).onErrorReturn(new Function(this){
            final /* synthetic */ AmityImageUploadService this$0;
            {
                this.this$0 = $receiver;
            }

            public final AmityUploadResult<AmityImage> apply(Throwable it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                AmityException exception = this.this$0.parseErrorResponse(it);
                return new AmityUploadResult.ERROR(exception);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"onErrorReturn(...)");
        return flowable;
    }

    public /* synthetic */ AmityImageUploadService(Uri uri, String uploadId, boolean isFullImage, String altText, DefaultConstructorMarker $constructor_marker) {
        this(uri, uploadId, isFullImage, altText);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u000b\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b\fJ\u000e\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u0007J\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/amity/socialcloud/sdk/infra/upload/AmityImageUploadService$Builder;", "", "<init>", "()V", "uri", "Landroid/net/Uri;", "uploadId", "", "isFullImage", "", "altText", "fileUri", "fileUri$amity_sdk_release", "build", "Lcom/amity/socialcloud/sdk/infra/upload/AmityImageUploadService;", "amity-sdk_release"})
    public static final class Builder {
        private Uri uri;
        @Nullable
        private String uploadId;
        private boolean isFullImage;
        @Nullable
        private String altText;

        @NotNull
        public final Builder fileUri$amity_sdk_release(@NotNull Uri uri) {
            Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
            this.uri = uri;
            return this;
        }

        @NotNull
        public final Builder uploadId(@NotNull String uploadId) {
            Intrinsics.checkNotNullParameter((Object)uploadId, (String)"uploadId");
            this.uploadId = uploadId;
            return this;
        }

        @NotNull
        public final Builder isFullImage(boolean isFullImage) {
            this.isFullImage = isFullImage;
            return this;
        }

        @NotNull
        public final Builder altText(@NotNull String altText) {
            Intrinsics.checkNotNullParameter((Object)altText, (String)"altText");
            this.altText = altText;
            return this;
        }

        @NotNull
        public final AmityImageUploadService build() {
            Uri uri = this.uri;
            if (uri == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"uri");
                uri = null;
            }
            return new AmityImageUploadService(uri, this.uploadId, this.isFullImage, this.altText, null);
        }
    }
}

