/*
 * Decompiled with CFR 0.152.
 */
package co.amity.rxremotemediator;

import androidx.annotation.NonNull;
import androidx.room.EntityInsertAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RxRoom;
import androidx.room.util.SQLiteStatementUtil;
import androidx.sqlite.SQLiteStatement;
import co.amity.rxremotemediator.AmityPagingId;
import co.amity.rxremotemediator.AmityQueryToken;
import co.amity.rxremotemediator.AmityQueryTokenDao;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.reactivex.Single;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kotlin.Unit;

public final class AmityQueryTokenDao_Impl
implements AmityQueryTokenDao {
    private final RoomDatabase __db;
    private final EntityInsertAdapter<AmityQueryToken> __insertAdapterOfAmityQueryToken;
    private final EntityInsertAdapter<AmityPagingId> __insertAdapterOfAmityPagingId;
    private final EntityInsertAdapter<AmityPagingId> __insertAdapterOfAmityPagingId_1;

    public AmityQueryTokenDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertAdapterOfAmityQueryToken = new EntityInsertAdapter<AmityQueryToken>(){

            @NonNull
            protected String createQuery() {
                return "INSERT OR REPLACE INTO `amity_query_token` (`next`,`previous`,`pageNumber`,`hash`,`nonce`) VALUES (?,?,?,?,?)";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull AmityQueryToken entity) {
                if (entity.getNext() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getNext());
                }
                if (entity.getPrevious() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindText(2, entity.getPrevious());
                }
                statement.bindLong(3, (long)entity.getPageNumber());
                statement.bindLong(4, (long)entity.getHash());
                statement.bindLong(5, (long)entity.getNonce());
            }
        };
        this.__insertAdapterOfAmityPagingId = new EntityInsertAdapter<AmityPagingId>(){

            @NonNull
            protected String createQuery() {
                return "INSERT OR REPLACE INTO `amity_paging_id` (`id`,`hash`,`nonce`,`position`) VALUES (?,?,?,?)";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull AmityPagingId entity) {
                if (entity.getId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getId());
                }
                statement.bindLong(2, (long)entity.getHash());
                statement.bindLong(3, (long)entity.getNonce());
                statement.bindLong(4, (long)entity.getPosition());
            }
        };
        this.__insertAdapterOfAmityPagingId_1 = new EntityInsertAdapter<AmityPagingId>(){

            @NonNull
            protected String createQuery() {
                return "INSERT OR IGNORE INTO `amity_paging_id` (`id`,`hash`,`nonce`,`position`) VALUES (?,?,?,?)";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull AmityPagingId entity) {
                if (entity.getId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getId());
                }
                statement.bindLong(2, (long)entity.getHash());
                statement.bindLong(3, (long)entity.getNonce());
                statement.bindLong(4, (long)entity.getPosition());
            }
        };
    }

    public Completable insertToken(AmityQueryToken token) {
        if (token == null) {
            throw new NullPointerException();
        }
        return RxRoom.createCompletable((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfAmityQueryToken.insert(_connection, (Object)token);
            return Unit.INSTANCE;
        });
    }

    public Completable insertPagingIds(List<AmityPagingId> pagingIds) {
        if (pagingIds == null) {
            throw new NullPointerException();
        }
        return RxRoom.createCompletable((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfAmityPagingId.insert(_connection, (Iterable)pagingIds);
            return Unit.INSTANCE;
        });
    }

    public Completable insertPagingIdsIgnoreStrategy(List<AmityPagingId> pagingIds) {
        if (pagingIds == null) {
            throw new NullPointerException();
        }
        return RxRoom.createCompletable((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfAmityPagingId_1.insert(_connection, (Iterable)pagingIds);
            return Unit.INSTANCE;
        });
    }

    public Single<Boolean> pagingIdExists(int hash, int nonce, String id) {
        String _sql = "select exists (SELECT 1 FROM amity_paging_id where hash = ? and nonce = ? and id = ?)";
        return RxRoom.createSingle((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("select exists (SELECT 1 FROM amity_paging_id where hash = ? and nonce = ? and id = ?)");){
                Integer _tmp;
                int _argIndex = 1;
                _stmt.bindLong(_argIndex, (long)hash);
                _argIndex = 2;
                _stmt.bindLong(_argIndex, (long)nonce);
                _argIndex = 3;
                if (id == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, id);
                }
                Boolean _result = _stmt.step() ? ((_tmp = _stmt.isNull(0) ? null : Integer.valueOf((int)_stmt.getLong(0))) == null ? null : Boolean.valueOf(_tmp != 0)) : null;
                Boolean bl = _result;
                return bl;
            }
        });
    }

    public Maybe<AmityQueryToken> getFirstQueryTokenImpl(int hash, int nonce) {
        String _sql = "select * from amity_query_token where hash = ? and nonce = ? order by pageNumber asc limit 1";
        return RxRoom.createMaybe((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("select * from amity_query_token where hash = ? and nonce = ? order by pageNumber asc limit 1");){
                AmityQueryToken _result;
                int _argIndex = 1;
                _stmt.bindLong(_argIndex, (long)hash);
                _argIndex = 2;
                _stmt.bindLong(_argIndex, (long)nonce);
                int _columnIndexOfNext = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"next");
                int _columnIndexOfPrevious = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"previous");
                int _columnIndexOfPageNumber = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pageNumber");
                int _columnIndexOfHash = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"hash");
                int _columnIndexOfNonce = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"nonce");
                if (_stmt.step()) {
                    _result = new AmityQueryToken();
                    String _tmpNext = _stmt.isNull(_columnIndexOfNext) ? null : _stmt.getText(_columnIndexOfNext);
                    _result.setNext(_tmpNext);
                    String _tmpPrevious = _stmt.isNull(_columnIndexOfPrevious) ? null : _stmt.getText(_columnIndexOfPrevious);
                    _result.setPrevious(_tmpPrevious);
                    int _tmpPageNumber = (int)_stmt.getLong(_columnIndexOfPageNumber);
                    _result.setPageNumber(_tmpPageNumber);
                    int _tmpHash = (int)_stmt.getLong(_columnIndexOfHash);
                    _result.setHash(_tmpHash);
                    int _tmpNonce = (int)_stmt.getLong(_columnIndexOfNonce);
                    _result.setNonce(_tmpNonce);
                } else {
                    _result = null;
                }
                AmityQueryToken amityQueryToken = _result;
                return amityQueryToken;
            }
        });
    }

    public Maybe<AmityQueryToken> getLastQueryTokenImpl(int hash, int nonce) {
        String _sql = "select * from amity_query_token where hash = ? and nonce = ? order by pageNumber desc limit 1";
        return RxRoom.createMaybe((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("select * from amity_query_token where hash = ? and nonce = ? order by pageNumber desc limit 1");){
                AmityQueryToken _result;
                int _argIndex = 1;
                _stmt.bindLong(_argIndex, (long)hash);
                _argIndex = 2;
                _stmt.bindLong(_argIndex, (long)nonce);
                int _columnIndexOfNext = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"next");
                int _columnIndexOfPrevious = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"previous");
                int _columnIndexOfPageNumber = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pageNumber");
                int _columnIndexOfHash = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"hash");
                int _columnIndexOfNonce = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"nonce");
                if (_stmt.step()) {
                    _result = new AmityQueryToken();
                    String _tmpNext = _stmt.isNull(_columnIndexOfNext) ? null : _stmt.getText(_columnIndexOfNext);
                    _result.setNext(_tmpNext);
                    String _tmpPrevious = _stmt.isNull(_columnIndexOfPrevious) ? null : _stmt.getText(_columnIndexOfPrevious);
                    _result.setPrevious(_tmpPrevious);
                    int _tmpPageNumber = (int)_stmt.getLong(_columnIndexOfPageNumber);
                    _result.setPageNumber(_tmpPageNumber);
                    int _tmpHash = (int)_stmt.getLong(_columnIndexOfHash);
                    _result.setHash(_tmpHash);
                    int _tmpNonce = (int)_stmt.getLong(_columnIndexOfNonce);
                    _result.setNonce(_tmpNonce);
                } else {
                    _result = null;
                }
                AmityQueryToken amityQueryToken = _result;
                return amityQueryToken;
            }
        });
    }

    public Maybe<AmityQueryToken> getTokenByPageNumberImpl(int pageNumber, int hash, int nonce) {
        String _sql = "select * from amity_query_token where pageNumber = ? and hash = ? and nonce = ? limit 1";
        return RxRoom.createMaybe((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("select * from amity_query_token where pageNumber = ? and hash = ? and nonce = ? limit 1");){
                AmityQueryToken _result;
                int _argIndex = 1;
                _stmt.bindLong(_argIndex, (long)pageNumber);
                _argIndex = 2;
                _stmt.bindLong(_argIndex, (long)hash);
                _argIndex = 3;
                _stmt.bindLong(_argIndex, (long)nonce);
                int _columnIndexOfNext = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"next");
                int _columnIndexOfPrevious = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"previous");
                int _columnIndexOfPageNumber = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pageNumber");
                int _columnIndexOfHash = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"hash");
                int _columnIndexOfNonce = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"nonce");
                if (_stmt.step()) {
                    _result = new AmityQueryToken();
                    String _tmpNext = _stmt.isNull(_columnIndexOfNext) ? null : _stmt.getText(_columnIndexOfNext);
                    _result.setNext(_tmpNext);
                    String _tmpPrevious = _stmt.isNull(_columnIndexOfPrevious) ? null : _stmt.getText(_columnIndexOfPrevious);
                    _result.setPrevious(_tmpPrevious);
                    int _tmpPageNumber = (int)_stmt.getLong(_columnIndexOfPageNumber);
                    _result.setPageNumber(_tmpPageNumber);
                    int _tmpHash = (int)_stmt.getLong(_columnIndexOfHash);
                    _result.setHash(_tmpHash);
                    int _tmpNonce = (int)_stmt.getLong(_columnIndexOfNonce);
                    _result.setNonce(_tmpNonce);
                } else {
                    _result = null;
                }
                AmityQueryToken amityQueryToken = _result;
                return amityQueryToken;
            }
        });
    }

    public Completable deleteAfterPositionImpl(int position, int hash, int nonce) {
        String _sql = "delete from amity_paging_id where position > ? and hash = ? and nonce = ?";
        return RxRoom.createCompletable((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("delete from amity_paging_id where position > ? and hash = ? and nonce = ?");){
                int _argIndex = 1;
                _stmt.bindLong(_argIndex, (long)position);
                _argIndex = 2;
                _stmt.bindLong(_argIndex, (long)hash);
                _argIndex = 3;
                _stmt.bindLong(_argIndex, (long)nonce);
                _stmt.step();
                Unit unit = Unit.INSTANCE;
                return unit;
            }
        });
    }

    public Completable deleteAfterPageNumberImpl(int pageNumber, int hash, int nonce) {
        String _sql = "delete from amity_query_token where pageNumber > ? and hash = ? and nonce = ?";
        return RxRoom.createCompletable((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("delete from amity_query_token where pageNumber > ? and hash = ? and nonce = ?");){
                int _argIndex = 1;
                _stmt.bindLong(_argIndex, (long)pageNumber);
                _argIndex = 2;
                _stmt.bindLong(_argIndex, (long)hash);
                _argIndex = 3;
                _stmt.bindLong(_argIndex, (long)nonce);
                _stmt.step();
                Unit unit = Unit.INSTANCE;
                return unit;
            }
        });
    }

    public Completable clearPagingIdsImpl(int hash, int nonce) {
        String _sql = "delete from amity_paging_id where hash = ? and nonce = ?";
        return RxRoom.createCompletable((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("delete from amity_paging_id where hash = ? and nonce = ?");){
                int _argIndex = 1;
                _stmt.bindLong(_argIndex, (long)hash);
                _argIndex = 2;
                _stmt.bindLong(_argIndex, (long)nonce);
                _stmt.step();
                Unit unit = Unit.INSTANCE;
                return unit;
            }
        });
    }

    public Completable clearQueryTokenImpl(int hash, int nonce) {
        String _sql = "delete from amity_query_token where hash = ? and nonce = ?";
        return RxRoom.createCompletable((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("delete from amity_query_token where hash = ? and nonce = ?");){
                int _argIndex = 1;
                _stmt.bindLong(_argIndex, (long)hash);
                _argIndex = 2;
                _stmt.bindLong(_argIndex, (long)nonce);
                _stmt.step();
                Unit unit = Unit.INSTANCE;
                return unit;
            }
        });
    }

    public Completable insertPagingIdsIfNeeded(AmityPagingId pagingId) {
        return AmityQueryTokenDao.DefaultImpls.insertPagingIdsIfNeeded((AmityQueryTokenDao)this, (AmityPagingId)pagingId);
    }

    public Completable deleteAfterPosition(int position, Map<String, ?> queryParameters, int nonce) {
        return AmityQueryTokenDao.DefaultImpls.deleteAfterPosition((AmityQueryTokenDao)this, (int)position, queryParameters, (int)nonce);
    }

    public Completable deleteAfterPageNumber(int pageNumber, Map<String, ?> queryParameters, int nonce) {
        return AmityQueryTokenDao.DefaultImpls.deleteAfterPageNumber((AmityQueryTokenDao)this, (int)pageNumber, queryParameters, (int)nonce);
    }

    public Completable clearPagingIds(Map<String, ?> queryParameters, int nonce) {
        return AmityQueryTokenDao.DefaultImpls.clearPagingIds((AmityQueryTokenDao)this, queryParameters, (int)nonce);
    }

    public Completable clearQueryToken(Map<String, ?> queryParameters, int nonce) {
        return AmityQueryTokenDao.DefaultImpls.clearQueryToken((AmityQueryTokenDao)this, queryParameters, (int)nonce);
    }

    public Maybe<AmityQueryToken> getFirstQueryToken(Map<String, ?> queryParameters, int nonce) {
        return AmityQueryTokenDao.DefaultImpls.getFirstQueryToken((AmityQueryTokenDao)this, queryParameters, (int)nonce);
    }

    public Maybe<AmityQueryToken> getLastQueryToken(Map<String, ?> queryParameters, int nonce) {
        return AmityQueryTokenDao.DefaultImpls.getLastQueryToken((AmityQueryTokenDao)this, queryParameters, (int)nonce);
    }

    public Maybe<String> getTokenByPageNumber(int pageNumber, Map<String, ?> queryParameters, int nonce) {
        return AmityQueryTokenDao.DefaultImpls.getTokenByPageNumber((AmityQueryTokenDao)this, (int)pageNumber, queryParameters, (int)nonce);
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

