package com.amity.socialcloud.sdk.core.domain.topic

import com.amity.socialcloud.sdk.api.core.AmityCoreClient
import com.amity.socialcloud.sdk.core.domain.user.UserObserveUseCase
import io.reactivex.rxjava3.core.Single

internal class LiveStreamTopicGeneratorUseCase : TopicGenerationUseCase() {

    fun execute(): Single<String> {
        return UserObserveUseCase().execute(AmityCoreClient.getUserId())
            .firstOrError()
            .map {
                val userPath = it.path
                val networkId = userPath.substringBefore("/")
                networkId + "/videostreaming"
            }
    }
}