package com.amity.socialcloud.sdk.core.data.room

import com.amity.socialcloud.sdk.common.QueryPersister
import com.amity.socialcloud.sdk.core.data.file.FileEntityMapper
import com.amity.socialcloud.sdk.core.data.file.FileLocalDataStore
import com.amity.socialcloud.sdk.core.data.user.UserEntityMapper
import com.amity.socialcloud.sdk.core.data.user.UserLocalDataStore
import com.amity.socialcloud.sdk.core.data.user.flag.UserFlagEntityMapper
import com.amity.socialcloud.sdk.core.data.user.flag.UserFlagLocalDataStore
import com.amity.socialcloud.sdk.dto.video.EkoRoomListDto
import io.reactivex.rxjava3.core.Completable

internal class RoomListQueryPersister : QueryPersister<EkoRoomListDto>() {
    override fun persist(dto: EkoRoomListDto): Completable {
        return FileLocalDataStore().saveFiles(FileEntityMapper().map(dto.files ?: emptyList()))
            .andThen(UserLocalDataStore().saveUsers(UserEntityMapper().map(dto.users ?: emptyList())))
            .andThen(UserFlagLocalDataStore().saveFlags(UserFlagEntityMapper().map(dto.users ?: emptyList())))
            // Moderations (if any)
            .andThen(RoomModerationLocalDataStore().saveModerations(RoomModerationEntityMapper().map(dto.roomModerations ?: emptyList())))
            // Child rooms first to ensure parent references valid
            .andThen(RoomLocalDataStore().saveRooms(RoomEntityMapper().map(dto.roomChildren ?: emptyList())))
            .andThen(RoomLocalDataStore().saveRooms(RoomEntityMapper().map(dto.rooms ?: emptyList())))
    }
}

