package com.ekoapp.ekosdk.internal.api.socket.request

import com.google.gson.JsonObject
import com.google.gson.annotations.SerializedName

/**
 * Request body for POST /api/v1/rooms
 * Fields based on spec:
 * - title (required)
 * - description (optional)
 * - thumbnailFileId (optional)
 * - metadata (optional object)
 * - channelEnabled (optional, default true)
 * - parentRoomId (optional)
 * - type (optional enum: directStreaming | coHosts, default directStreaming)
 * - participants (optional list of userIds, applicable for coHosts)
 */
 data class CreateRoomRequest(
    @SerializedName("title") val title: String,
    @SerializedName("description") val description: String? = null,
    @SerializedName("thumbnailFileId") val thumbnailFileId: String? = null,
    @SerializedName("metadata") val metadata: JsonObject? = null,
    @SerializedName("channelEnabled") val channelEnabled: Boolean? = true,
    @SerializedName("parentRoomId") val parentRoomId: String? = null,
    @SerializedName("type") val type: String? = "directStreaming",
    @SerializedName("participants") val participants: List<String>? = null,
 )
