package com.ekoapp.ekosdk.internal.api.mapper

import com.amity.socialcloud.sdk.model.core.error.AmityError
import com.amity.socialcloud.sdk.model.core.error.AmityException
import com.ekoapp.ekosdk.internal.api.dto.EkoCommunityMembershipDto
import com.ekoapp.ekosdk.internal.entity.CommunityMembershipEntity

interface EkoCommunityMembershipMapper : EkoObjectMapper<EkoCommunityMembershipDto, CommunityMembershipEntity> {
	override fun update(objectOnDisk: CommunityMembershipEntity, objectToSave: CommunityMembershipEntity): CommunityMembershipEntity {
		return if (objectToSave.updatedAt.isAfter(objectOnDisk.updatedAt)
				|| objectToSave.updatedAt.isEqual(objectOnDisk.updatedAt)) {
			objectToSave
		} else objectOnDisk
	}
	
	companion object {
		val MAPPER: EkoCommunityMembershipMapper = object: EkoCommunityMembershipMapper {
			override fun map(dto: EkoCommunityMembershipDto): CommunityMembershipEntity {
				if (dto.userId != null && !dto.userId.isEmpty() && dto.communityId != null && !dto.communityId.isEmpty()) {
					val communityMembership = CommunityMembershipEntity()
					communityMembership.id = dto.getId()
					communityMembership.communityId = dto.communityId
					communityMembership.channelId = dto.channelId
					communityMembership.userId = dto.userId
					communityMembership.communityMembership = dto.communityMembership
					communityMembership.metadata = dto.metadata
					communityMembership.isBanned = dto.isBanned
					communityMembership.createdAt = dto.createdAt
					communityMembership.updatedAt = dto.updatedAt
					communityMembership.roles = dto.roles
					communityMembership.permissions = dto.permissions
					return communityMembership
				} else {
					return throw AmityException.create("Fail to persist community membership", null, AmityError.UNKNOWN)
				}
			}
		}
	}
}