package com.amity.socialcloud.sdk.video.domain.room.compose

import com.amity.socialcloud.sdk.core.domain.user.UserGetUseCase
import com.amity.socialcloud.sdk.chat.domain.channel.GetChannelUseCase
import com.amity.socialcloud.sdk.core.data.room.RoomRepository
import com.amity.socialcloud.sdk.model.video.room.AmityRoom

internal class RoomComposerUseCase {

    private val roomRepository = RoomRepository()

    fun execute(room: AmityRoom): AmityRoom {
        addCreator(room)
        addChannel(room)
        addModeration(room)
        // TODO: participants enrichment & child rooms if hierarchical rooms implemented
        return room
    }

    private fun addCreator(room: AmityRoom) {
        room.getCreatorId()?.let { id ->
            room.creator = UserGetUseCase().execute(id)
        }
    }

    private fun addChannel(room: AmityRoom) {
        room.getChannelId()?.let { channelId ->
            room.channel = GetChannelUseCase().execute(channelId)
        }
    }

    private fun addModeration(room: AmityRoom) {
        room.moderation = roomRepository.getRoomModerationByRoom(room.getRoomId())
    }
}

