package com.amity.socialcloud.sdk.core.data.room

import com.amity.socialcloud.sdk.common.QueryPersister
import com.amity.socialcloud.sdk.core.data.file.FileEntityMapper
import com.amity.socialcloud.sdk.core.data.file.FileLocalDataStore
import com.amity.socialcloud.sdk.core.data.user.UserEntityMapper
import com.amity.socialcloud.sdk.core.data.user.UserLocalDataStore
import com.amity.socialcloud.sdk.core.data.user.flag.UserFlagEntityMapper
import com.amity.socialcloud.sdk.core.data.user.flag.UserFlagLocalDataStore
import com.amity.socialcloud.sdk.dto.video.EkoRoomQueryDto
import io.reactivex.rxjava3.core.Completable

internal class RoomListQueryPersister : QueryPersister<EkoRoomQueryDto>() {
    override fun persist(dto: EkoRoomQueryDto): Completable {
        val result = dto.result
        return FileLocalDataStore().saveFiles(FileEntityMapper().map(result.files ?: emptyList()))
            .andThen(UserLocalDataStore().saveUsers(UserEntityMapper().map(result.users ?: emptyList())))
            .andThen(UserFlagLocalDataStore().saveFlags(UserFlagEntityMapper().map(result.users ?: emptyList())))
            // Moderations (if any)
            .andThen(RoomModerationLocalDataStore().saveModerations(RoomModerationEntityMapper().map(result.roomModerations ?: emptyList())))
            // Child rooms first to ensure parent references valid
            .andThen(RoomLocalDataStore().saveRooms(RoomEntityMapper().map(result.roomChildren ?: emptyList())))
            .andThen(RoomLocalDataStore().saveRooms(RoomEntityMapper().map(result.rooms ?: emptyList())))
    }
}

