package com.amity.socialcloud.sdk.core.data.room

import com.amity.socialcloud.sdk.common.EntityMapper
import com.amity.socialcloud.sdk.dto.video.EkoRoomDto
import com.amity.socialcloud.sdk.entity.video.room.RoomEntity

internal class RoomEntityMapper : EntityMapper<EkoRoomDto, RoomEntity>() {
    override fun map(list: List<EkoRoomDto>): List<RoomEntity> = list.map { map(it) }

    private fun map(dto: EkoRoomDto): RoomEntity = RoomEntity().apply {
        roomId = dto.roomId ?: ""
        type = dto.type
        targetType = dto.targetType
        targetId = dto.targetId
        referenceType = dto.referenceType
        referenceId = dto.referenceId
        channelEnabled = dto.liveChannelEnabled ?: false
        channelId = dto.liveChannelId
        title = dto.title
        description = dto.description
        thumbnailFileId = dto.thumbnailFileId
        status = dto.status
        participants = dto.participants?.mapNotNull { it.get("userId")?.asString }
        livePlaybackUrl = dto.livePlaybackUrl
        durationSeconds = dto.durationSeconds
        parentRoomId = dto.parentRoomId
        childRoomIds = dto.childRoomIds
        creatorId = dto.createdBy
        isDeleted = dto.isDeleted
        deletedAt = dto.deletedAt
        deletedById = dto.deletedBy
        metadata = dto.metadata
        liveAt = dto.liveAt
        endedAt = dto.endedAt
        recordedAt = dto.recordedAt
        setCreatedAt(dto.createdAt)
        setUpdatedAt(dto.updatedAt)
    }
}

