/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.core.data.user;

import androidx.paging.PagingConfig;
import androidx.paging.PagingData;
import androidx.paging.PagingSource;
import co.amity.rxbridge.FlowableKt;
import com.amity.socialcloud.sdk.api.core.user.search.AmityUserSearchMatchType;
import com.amity.socialcloud.sdk.api.core.user.search.AmityUserSortOption;
import com.amity.socialcloud.sdk.chat.data.channel.membership.ChannelMembershipLocalDataStore;
import com.amity.socialcloud.sdk.chat.data.message.MessageLocalDataStore;
import com.amity.socialcloud.sdk.common.AmityObjectRepository;
import com.amity.socialcloud.sdk.common.ModelMapper;
import com.amity.socialcloud.sdk.core.data.follow.FollowLocalDataStore;
import com.amity.socialcloud.sdk.core.data.user.UserLocalDataStore;
import com.amity.socialcloud.sdk.core.data.user.UserModelMapper;
import com.amity.socialcloud.sdk.core.data.user.UserQueryPersister;
import com.amity.socialcloud.sdk.core.data.user.UserRemoteDataStore;
import com.amity.socialcloud.sdk.core.data.user.UserRepository;
import com.amity.socialcloud.sdk.core.data.user.paging.UserMediator;
import com.amity.socialcloud.sdk.entity.core.user.UserEntity;
import com.amity.socialcloud.sdk.model.core.user.AmityUser;
import com.amity.socialcloud.sdk.model.core.user.UserUpdateOption;
import com.amity.socialcloud.sdk.social.data.community.membership.CommunityMembershipLocalDataStore;
import com.ekoapp.ekosdk.internal.api.dto.EkoUserListDto;
import com.ekoapp.ekosdk.internal.paging.DynamicQueryStreamPagerCreator;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleSource;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.functions.Function;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00022\u0006\u0010\b\u001a\u00020\tH\u0016J\u0014\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\fH\u0016J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u000e2\u0006\u0010\b\u001a\u00020\tH\u0016J.\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00100\u000e2\b\u0010\u0011\u001a\u0004\u0018\u00010\t2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0017\u001a\u00020\tJ\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0017\u001a\u00020\tJ \u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u001a0\u000e2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\t0\u001aJ\u001c\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00030\u001d2\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010 \u001a\u00020!2\u0006\u0010\u0017\u001a\u00020\tJ\u000e\u0010\"\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\tJ\u000e\u0010#\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\tJ\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020!0\u001d2\u0006\u0010\u0017\u001a\u00020\tJ\u001a\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\u001d2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\t0\u001aJ\u0015\u0010'\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b(J\b\u0010)\u001a\u00020*H\u0002\u00a8\u0006+"}, d2={"Lcom/amity/socialcloud/sdk/core/data/user/UserRepository;", "Lcom/amity/socialcloud/sdk/common/AmityObjectRepository;", "Lcom/amity/socialcloud/sdk/entity/core/user/UserEntity;", "Lcom/amity/socialcloud/sdk/model/core/user/AmityUser;", "<init>", "()V", "fetchAndSave", "Lio/reactivex/rxjava3/core/Completable;", "objectId", "", "queryFromCache", "mapper", "Lcom/amity/socialcloud/sdk/common/ModelMapper;", "observeFromCache", "Lio/reactivex/rxjava3/core/Flowable;", "getUserPagingData", "Landroidx/paging/PagingData;", "keyword", "matchType", "Lcom/amity/socialcloud/sdk/api/core/user/search/AmityUserSearchMatchType;", "sortBy", "Lcom/amity/socialcloud/sdk/api/core/user/search/AmityUserSortOption;", "getUser", "userId", "getUserNow", "getUserByIds", "", "userIds", "updateUser", "Lio/reactivex/rxjava3/core/Single;", "option", "Lcom/amity/socialcloud/sdk/model/core/user/UserUpdateOption;", "hasInLocal", "", "flagUser", "unflagUser", "isFlaggedByMe", "getUserDtoByIds", "Lcom/ekoapp/ekosdk/internal/api/dto/EkoUserListDto;", "notifyUserUpdate", "notifyUserUpdate$amity_sdk_release", "getDefaultPageSize", "", "amity-sdk_release"})
public final class UserRepository
extends AmityObjectRepository<UserEntity, AmityUser> {
    @Override
    @NotNull
    public Completable fetchAndSave(@NotNull String objectId) {
        Intrinsics.checkNotNullParameter((Object)objectId, (String)"objectId");
        Completable completable = new UserRemoteDataStore().getUser(objectId).flatMap((Function)fetchAndSave.1.INSTANCE).doOnSuccess((Consumer)fetchAndSave.2.INSTANCE).ignoreElement();
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"ignoreElement(...)");
        return completable;
    }

    @Override
    @Nullable
    public UserEntity queryFromCache(@NotNull String objectId) {
        Intrinsics.checkNotNullParameter((Object)objectId, (String)"objectId");
        return new UserLocalDataStore().getUser(objectId);
    }

    @Override
    @NotNull
    public ModelMapper<UserEntity, AmityUser> mapper() {
        return new UserModelMapper();
    }

    @Override
    @NotNull
    public Flowable<UserEntity> observeFromCache(@NotNull String objectId) {
        Intrinsics.checkNotNullParameter((Object)objectId, (String)"objectId");
        return new UserLocalDataStore().observeUser(objectId);
    }

    @NotNull
    public final Flowable<PagingData<AmityUser>> getUserPagingData(@Nullable String keyword, @Nullable AmityUserSearchMatchType matchType, @NotNull AmityUserSortOption sortBy) {
        Intrinsics.checkNotNullParameter((Object)((Object)sortBy), (String)"sortBy");
        AmityUserSearchMatchType amityUserSearchMatchType = matchType;
        DynamicQueryStreamPagerCreator pagerCreator = new DynamicQueryStreamPagerCreator(new PagingConfig(this.getDefaultPageSize(), 0, true, 0, 0, 0, 58, null), null, new UserMediator(keyword, amityUserSearchMatchType != null ? amityUserSearchMatchType.getValue() : null, sortBy), () -> UserRepository.getUserPagingData$lambda$0(keyword, matchType, sortBy), (ModelMapper)new UserModelMapper(), 2, null);
        return FlowableKt.toRx3(pagerCreator.create());
    }

    @Nullable
    public final AmityUser getUser(@NotNull String userId) {
        AmityUser amityUser;
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        UserEntity userEntity = new UserLocalDataStore().getUser(userId);
        if (userEntity != null) {
            UserEntity it = userEntity;
            boolean bl = false;
            amityUser = new UserModelMapper().map(it);
        } else {
            amityUser = null;
        }
        return amityUser;
    }

    @Nullable
    public final AmityUser getUserNow(@NotNull String userId) {
        AmityUser amityUser;
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        UserEntity userEntity = new UserLocalDataStore().getUserNow(userId);
        if (userEntity != null) {
            UserEntity it = userEntity;
            boolean bl = false;
            amityUser = new UserModelMapper().map(it);
        } else {
            amityUser = null;
        }
        return amityUser;
    }

    @NotNull
    public final Flowable<List<AmityUser>> getUserByIds(@NotNull List<String> userIds) {
        Intrinsics.checkNotNullParameter(userIds, (String)"userIds");
        Flowable flowable = new UserRemoteDataStore().getUserByIds(userIds).flatMap((Function)getUserByIds.1.INSTANCE).flatMapPublisher((Function)getUserByIds.2.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"flatMapPublisher(...)");
        return flowable;
    }

    @NotNull
    public final Single<AmityUser> updateUser(@NotNull String userId, @NotNull UserUpdateOption option) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        Single single = new UserRemoteDataStore().updateUser(userId, option).flatMap((Function)updateUser.1.INSTANCE).flatMap(new Function(this){
            final /* synthetic */ UserRepository this$0;
            {
                this.this$0 = $receiver;
            }

            /*
             * Enabled aggressive block sorting
             */
            public final SingleSource<? extends AmityUser> apply(String userId) {
                SingleSource singleSource;
                Intrinsics.checkNotNull((Object)userId);
                AmityUser amityUser = this.this$0.getUser(userId);
                if (amityUser != null) {
                    AmityUser it = amityUser;
                    boolean bl = false;
                    Single single = Single.just((Object)it);
                    amityUser = single;
                    if (single != null) {
                        singleSource = (SingleSource)amityUser;
                        return singleSource;
                    }
                }
                singleSource = (SingleSource)Single.never();
                return singleSource;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"flatMap(...)");
        return single;
    }

    public final boolean hasInLocal(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        return new UserLocalDataStore().getUser(userId) != null;
    }

    @NotNull
    public final Completable flagUser(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Completable completable = new UserRemoteDataStore().flagUser(userId).flatMapCompletable(new Function(this, userId){
            final /* synthetic */ UserRepository this$0;
            final /* synthetic */ String $userId;
            {
                this.this$0 = $receiver;
                this.$userId = $userId;
            }

            public final CompletableSource apply(EkoUserListDto it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (CompletableSource)new UserQueryPersister().persist(it).andThen((CompletableSource)this.this$0.notifyUserUpdate$amity_sdk_release(this.$userId));
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"flatMapCompletable(...)");
        return completable;
    }

    @NotNull
    public final Completable unflagUser(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Completable completable = new UserRemoteDataStore().unflagUser(userId).flatMapCompletable(new Function(this, userId){
            final /* synthetic */ UserRepository this$0;
            final /* synthetic */ String $userId;
            {
                this.this$0 = $receiver;
                this.$userId = $userId;
            }

            public final CompletableSource apply(EkoUserListDto it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (CompletableSource)new UserQueryPersister().persist(it).andThen((CompletableSource)this.this$0.notifyUserUpdate$amity_sdk_release(this.$userId));
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"flatMapCompletable(...)");
        return completable;
    }

    @NotNull
    public final Single<Boolean> isFlaggedByMe(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Single single = new UserRemoteDataStore().isFlaggedByMe(userId).map((Function)isFlaggedByMe.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"map(...)");
        return single;
    }

    @NotNull
    public final Single<EkoUserListDto> getUserDtoByIds(@NotNull List<String> userIds) {
        Intrinsics.checkNotNullParameter(userIds, (String)"userIds");
        return new UserRemoteDataStore().getUserByIds(userIds);
    }

    @NotNull
    public final Completable notifyUserUpdate$amity_sdk_release(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Completable completable = Completable.fromAction(() -> UserRepository.notifyUserUpdate$lambda$3(userId));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"fromAction(...)");
        return completable;
    }

    private final int getDefaultPageSize() {
        return 20;
    }

    private static final PagingSource getUserPagingData$lambda$0(String $keyword, AmityUserSearchMatchType $matchType, AmityUserSortOption $sortBy) {
        return new UserLocalDataStore().getUserPagingSource($keyword, $matchType, $sortBy);
    }

    private static final void notifyUserUpdate$lambda$3(String $userId) {
        new MessageLocalDataStore().notifyUserUpdate($userId);
        new ChannelMembershipLocalDataStore().notifyUserUpdate($userId);
        new CommunityMembershipLocalDataStore().notifyUserUpdate($userId);
        new FollowLocalDataStore().notifyUserUpdate($userId);
    }
}

