package com.amity.socialcloud.sdk.model.core.tag

import android.os.Parcelable
import kotlinx.parcelize.Parcelize

@Parcelize
class AmityTags(private val tags : List<String>) : ArrayList<String>(tags), Parcelable {

    constructor() : this(mutableListOf())

    constructor(tags : Set<String>) : this(tags.toList())

    fun get() : List<String> {
        return this.filter { it.isNotEmpty() }
    }
}
