/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.model;

import androidx.room.Entity;
import com.ekoapp.ekosdk.internal.data.model.EkoTagObject;
import com.ekoapp.ekosdk.internal.util.EkoPreconditions;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0096\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0012"}, d2={"Lcom/ekoapp/ekosdk/internal/data/model/EkoMessageTag;", "Lcom/ekoapp/ekosdk/internal/data/model/EkoTagObject;", "messageId", "", "tagName", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getMessageId", "()Ljava/lang/String;", "getTagName", "equals", "", "obj", "", "hashCode", "", "toString", "Companion", "amity-sdk_release"})
@Entity(tableName="message_tag", primaryKeys={"messageId", "tagName"})
public final class EkoMessageTag
extends EkoTagObject {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String messageId;
    @NotNull
    private final String tagName;
    @NotNull
    private static final EkoTagObject.EkoTagFactory<EkoMessageTag> factory = new EkoTagObject.EkoTagFactory<EkoMessageTag>(){

        public EkoMessageTag create(String id, String tag) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            String messageId = EkoPreconditions.checkValidId(id, "messageId");
            String tagName = EkoPreconditions.checkValidId(tag, "tagName");
            return new EkoMessageTag(messageId, tagName);
        }
    };

    public EkoMessageTag(@NotNull String messageId, @NotNull String tagName) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        Intrinsics.checkNotNullParameter((Object)tagName, (String)"tagName");
        this.messageId = messageId;
        this.tagName = tagName;
    }

    @NotNull
    public final String getMessageId() {
        return this.messageId;
    }

    @NotNull
    public final String getTagName() {
        return this.tagName;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!Intrinsics.areEqual(obj.getClass(), this.getClass())) {
            return false;
        }
        EkoMessageTag other = (EkoMessageTag)obj;
        return Objects.equal((Object)this.messageId, (Object)other.messageId) && Objects.equal((Object)this.tagName, (Object)other.tagName);
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.messageId, this.tagName};
        return Objects.hashCode((Object[])objectArray);
    }

    @NotNull
    public String toString() {
        String string = MoreObjects.toStringHelper((Object)this).add("messageId", (Object)this.messageId).add("tagName", (Object)this.tagName).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/ekoapp/ekosdk/internal/data/model/EkoMessageTag$Companion;", "", "<init>", "()V", "factory", "Lcom/ekoapp/ekosdk/internal/data/model/EkoTagObject$EkoTagFactory;", "Lcom/ekoapp/ekosdk/internal/data/model/EkoMessageTag;", "getFactory", "()Lcom/ekoapp/ekosdk/internal/data/model/EkoTagObject$EkoTagFactory;", "amity-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final EkoTagObject.EkoTagFactory<EkoMessageTag> getFactory() {
            return factory;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

