/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.video.domain.stream;

import com.amity.socialcloud.sdk.entity.video.stream.EkoStreamSessionEntity;
import com.amity.socialcloud.sdk.video.data.session.StreamSessionRepository;
import com.ekoapp.ekosdk.AmityNetworkUtils;
import com.ekoapp.ekosdk.internal.api.AmityHttpClient;
import com.ekoapp.ekosdk.internal.api.EkoStreamApi;
import com.ekoapp.ekosdk.internal.api.http.request.StreamSessionRequest;
import com.ekoapp.ekosdk.internal.api.http.request.StreamSessionRequestCreator;
import com.ekoapp.ekosdk.internal.data.EkoDatabase;
import com.ekoapp.ekosdk.internal.data.model.EkoApiKey;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.functions.Predicate;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u001c\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fJ\b\u0010\r\u001a\u00020\fH\u0002J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J\u001e\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002J\u0016\u0010\u0014\u001a\u00020\u00152\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002J\u0016\u0010\u0016\u001a\u00020\u00152\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/amity/socialcloud/sdk/video/domain/stream/SendStreamSessionUseCase;", "", "<init>", "()V", "retryCount", "", "execute", "Lio/reactivex/rxjava3/core/Completable;", "streamSessions", "", "Lcom/amity/socialcloud/sdk/entity/video/stream/EkoStreamSessionEntity;", "requireNetwork", "", "shouldSend", "getApiKey", "Lio/reactivex/rxjava3/core/Maybe;", "Lcom/ekoapp/ekosdk/internal/data/model/EkoApiKey;", "sendToServer", "apiKey", "", "markAsSynced", "", "markAsFailed", "amity-sdk_release"})
public final class SendStreamSessionUseCase {
    private int retryCount;

    @NotNull
    public final Completable execute(@NotNull List<EkoStreamSessionEntity> streamSessions) {
        Intrinsics.checkNotNullParameter(streamSessions, (String)"streamSessions");
        Completable completable = this.getApiKey().flatMapCompletable(new Function(this, streamSessions){
            final /* synthetic */ SendStreamSessionUseCase this$0;
            final /* synthetic */ List<EkoStreamSessionEntity> $streamSessions;
            {
                this.this$0 = $receiver;
                this.$streamSessions = $streamSessions;
            }

            public final CompletableSource apply(EkoApiKey it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                String string = it.getApiKey();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getApiKey(...)");
                return (CompletableSource)SendStreamSessionUseCase.access$sendToServer(this.this$0, string, this.$streamSessions);
            }
        }).doOnComplete(() -> SendStreamSessionUseCase.execute$lambda$0(this, streamSessions)).doOnError(new Consumer(this, streamSessions){
            final /* synthetic */ SendStreamSessionUseCase this$0;
            final /* synthetic */ List<EkoStreamSessionEntity> $streamSessions;
            {
                this.this$0 = $receiver;
                this.$streamSessions = $streamSessions;
            }

            public final void accept(Throwable it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                SendStreamSessionUseCase.access$markAsFailed(this.this$0, this.$streamSessions);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"doOnError(...)");
        return completable;
    }

    @NotNull
    public final Completable execute(@NotNull List<EkoStreamSessionEntity> streamSessions, boolean requireNetwork) {
        Completable completable;
        Intrinsics.checkNotNullParameter(streamSessions, (String)"streamSessions");
        if (streamSessions.isEmpty()) {
            Completable completable2 = Completable.complete();
            Intrinsics.checkNotNull((Object)completable2);
            completable = completable2;
        } else if (requireNetwork) {
            Completable completable3 = Flowable.interval((long)1L, (TimeUnit)TimeUnit.SECONDS).filter(new Predicate(this){
                final /* synthetic */ SendStreamSessionUseCase this$0;
                {
                    this.this$0 = $receiver;
                }

                public final boolean test(Long it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return SendStreamSessionUseCase.access$shouldSend(this.this$0);
                }
            }).takeUntil(new Predicate(this){
                final /* synthetic */ SendStreamSessionUseCase this$0;
                {
                    this.this$0 = $receiver;
                }

                public final boolean test(Long it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return SendStreamSessionUseCase.access$getRetryCount$p(this.this$0) >= 60;
                }
            }).firstOrError().flatMapCompletable(new Function(this, streamSessions){
                final /* synthetic */ SendStreamSessionUseCase this$0;
                final /* synthetic */ List<EkoStreamSessionEntity> $streamSessions;
                {
                    this.this$0 = $receiver;
                    this.$streamSessions = $streamSessions;
                }

                public final CompletableSource apply(Long it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return (CompletableSource)this.this$0.execute(this.$streamSessions);
                }
            });
            Intrinsics.checkNotNull((Object)completable3);
            completable = completable3;
        } else {
            completable = this.execute(streamSessions);
        }
        return completable;
    }

    private final boolean shouldSend() {
        boolean bl;
        if (AmityNetworkUtils.Companion.isNetworkAvailable()) {
            bl = true;
        } else {
            int n = this.retryCount;
            this.retryCount = n + 1;
            bl = false;
        }
        return bl;
    }

    private final Maybe<EkoApiKey> getApiKey() {
        Maybe<EkoApiKey> maybe = EkoDatabase.get().apiKeyDao().getCurrentApiKey();
        Intrinsics.checkNotNullExpressionValue(maybe, (String)"getCurrentApiKey(...)");
        return maybe;
    }

    private final Completable sendToServer(String apiKey, List<EkoStreamSessionEntity> streamSessions) {
        new StreamSessionRepository().markAsSyncing(streamSessions);
        StreamSessionRequest request = new StreamSessionRequestCreator(streamSessions).create();
        Completable completable = AmityHttpClient.Companion.get(Reflection.getOrCreateKotlinClass(EkoStreamApi.class)).flatMapCompletable(new Function(apiKey, request){
            final /* synthetic */ String $apiKey;
            final /* synthetic */ StreamSessionRequest $request;
            {
                this.$apiKey = $apiKey;
                this.$request = $request;
            }

            public final CompletableSource apply(EkoStreamApi it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (CompletableSource)it.sendStreamSession(this.$apiKey, this.$request);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"flatMapCompletable(...)");
        return completable;
    }

    private final void markAsSynced(List<EkoStreamSessionEntity> streamSessions) {
        new StreamSessionRepository().markAsSynced(streamSessions);
    }

    private final void markAsFailed(List<EkoStreamSessionEntity> streamSessions) {
        new StreamSessionRepository().markAsFailed(streamSessions);
    }

    private static final void execute$lambda$0(SendStreamSessionUseCase this$0, List $streamSessions) {
        this$0.markAsSynced($streamSessions);
    }

    public static final /* synthetic */ Completable access$sendToServer(SendStreamSessionUseCase $this, String apiKey, List streamSessions) {
        return $this.sendToServer(apiKey, streamSessions);
    }

    public static final /* synthetic */ void access$markAsFailed(SendStreamSessionUseCase $this, List streamSessions) {
        $this.markAsFailed(streamSessions);
    }

    public static final /* synthetic */ boolean access$shouldSend(SendStreamSessionUseCase $this) {
        return $this.shouldSend();
    }

    public static final /* synthetic */ int access$getRetryCount$p(SendStreamSessionUseCase $this) {
        return $this.retryCount;
    }
}

