/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.core.data.user;

import androidx.paging.PagingSource;
import com.amity.socialcloud.sdk.api.core.user.search.AmityUserSearchMatchType;
import com.amity.socialcloud.sdk.api.core.user.search.AmityUserSortOption;
import com.amity.socialcloud.sdk.core.data.user.UserDao;
import com.amity.socialcloud.sdk.core.data.user.UserLocalDataStore;
import com.amity.socialcloud.sdk.entity.core.user.UserEntity;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.entity.UserPresenceEntity;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J\u0014\u0010\t\u001a\u00020\u00052\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0007J\u0010\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u0004\u0018\u00010\b2\u0006\u0010\r\u001a\u00020\u000eJ \u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0007J\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\u00112\u0006\u0010\r\u001a\u00020\u000eJ.\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\b0\u00152\b\u0010\u0017\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001b\u00a8\u0006\u001c"}, d2={"Lcom/amity/socialcloud/sdk/core/data/user/UserLocalDataStore;", "", "<init>", "()V", "saveUsers", "Lio/reactivex/rxjava3/core/Completable;", "users", "", "Lcom/amity/socialcloud/sdk/entity/core/user/UserEntity;", "saveUserPresence", "presences", "Lcom/ekoapp/ekosdk/internal/entity/UserPresenceEntity;", "getUser", "userId", "", "getUserNow", "getUserByIds", "Lio/reactivex/rxjava3/core/Flowable;", "userIds", "observeUser", "getUserPagingSource", "Landroidx/paging/PagingSource;", "", "keyword", "matchType", "Lcom/amity/socialcloud/sdk/api/core/user/search/AmityUserSearchMatchType;", "sortBy", "Lcom/amity/socialcloud/sdk/api/core/user/search/AmityUserSortOption;", "amity-sdk_release"})
@SourceDebugExtension(value={"SMAP\nUserLocalDataStore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UserLocalDataStore.kt\ncom/amity/socialcloud/sdk/core/data/user/UserLocalDataStore\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,86:1\n1617#2,9:87\n1869#2:96\n1870#2:98\n1626#2:99\n1#3:97\n*S KotlinDebug\n*F\n+ 1 UserLocalDataStore.kt\ncom/amity/socialcloud/sdk/core/data/user/UserLocalDataStore\n*L\n25#1:87,9\n25#1:96\n25#1:98\n25#1:99\n25#1:97\n*E\n"})
public final class UserLocalDataStore {
    @NotNull
    public final Completable saveUsers(@NotNull List<? extends UserEntity> users) {
        Intrinsics.checkNotNullParameter(users, (String)"users");
        Completable completable = Completable.fromAction(() -> UserLocalDataStore.saveUsers$lambda$0(users));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"fromAction(...)");
        return completable;
    }

    @NotNull
    public final Completable saveUserPresence(@NotNull List<UserPresenceEntity> presences) {
        Intrinsics.checkNotNullParameter(presences, (String)"presences");
        Completable completable = Completable.fromAction(() -> UserLocalDataStore.saveUserPresence$lambda$2(presences));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"fromAction(...)");
        return completable;
    }

    @Nullable
    public final UserEntity getUser(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Ref.ObjectRef user = new Ref.ObjectRef();
        Completable.fromCallable(() -> UserLocalDataStore.getUser$lambda$3(userId, user)).subscribeOn(Schedulers.io()).blockingAwait();
        return (UserEntity)user.element;
    }

    @Nullable
    public final UserEntity getUserNow(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        UserEntity user = null;
        UserEntity entity = UserDatabase.get().userDao().getByIdNow(userId);
        if (entity != null) {
            user = entity;
        }
        return user;
    }

    @NotNull
    public final Flowable<List<UserEntity>> getUserByIds(@NotNull List<String> userIds) {
        Intrinsics.checkNotNullParameter(userIds, (String)"userIds");
        Flowable<List<UserEntity>> flowable = UserDatabase.get().userDao().getByUserIds(userIds);
        Intrinsics.checkNotNullExpressionValue(flowable, (String)"getByUserIds(...)");
        return flowable;
    }

    @NotNull
    public final Flowable<UserEntity> observeUser(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Flowable flowable = UserDatabase.get().userDao().observeUser(userId).map((Function)observeUser.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"map(...)");
        return flowable;
    }

    @NotNull
    public final PagingSource<Integer, UserEntity> getUserPagingSource(@Nullable String keyword, @Nullable AmityUserSearchMatchType matchType, @NotNull AmityUserSortOption sortBy) {
        Intrinsics.checkNotNullParameter((Object)((Object)sortBy), (String)"sortBy");
        return UserDatabase.get().userPagingDao().getUserPagingSource(keyword, matchType, sortBy);
    }

    private static final void saveUsers$lambda$0(List $users) {
        UserDatabase.get().userDao().save($users);
    }

    /*
     * WARNING - void declaration
     */
    private static final void saveUserPresence$lambda$2(List $presences) {
        void $this$mapNotNullTo$iv$iv;
        UserDao userDao = UserDatabase.get().userDao();
        Iterable $this$mapNotNull$iv = $presences;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            UserEntity it$iv$iv;
            UserEntity entity;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            UserPresenceEntity presence = (UserPresenceEntity)element$iv$iv;
            boolean bl2 = false;
            UserEntity userEntity = entity = userDao.getByIdNow(presence.getUserId());
            if (userEntity != null) {
                userEntity.setLastHeartbeat(presence.getLastHeartbeat());
            }
            if (entity == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List entities = (List)destination$iv$iv;
        userDao.save(entities);
    }

    private static final Unit getUser$lambda$3(String $userId, Ref.ObjectRef $user) {
        UserEntity entity = UserDatabase.get().userDao().getByIdNow($userId);
        if (entity != null) {
            $user.element = entity;
        }
        return Unit.INSTANCE;
    }
}

