/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import androidx.annotation.NonNull;
import androidx.room.EntityDeleteOrUpdateAdapter;
import androidx.room.EntityInsertAdapter;
import androidx.room.RoomDatabase;
import androidx.room.rxjava3.RxRoom;
import androidx.room.util.DBUtil;
import androidx.room.util.SQLiteStatementUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.SQLiteStatement;
import com.ekoapp.ekosdk.internal.EkoFileEntity;
import com.ekoapp.ekosdk.internal.data.converter.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.JsonObjectTypeConverter;
import com.ekoapp.ekosdk.internal.data.dao.EkoFileDao;
import com.google.gson.JsonObject;
import io.reactivex.rxjava3.core.Single;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kotlin.Unit;
import org.joda.time.DateTime;

public final class EkoFileDao_Impl
extends EkoFileDao {
    private final RoomDatabase __db;
    private final EntityInsertAdapter<EkoFileEntity> __insertAdapterOfEkoFileEntity;
    private final JsonObjectTypeConverter __jsonObjectTypeConverter = new JsonObjectTypeConverter();
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EntityDeleteOrUpdateAdapter<EkoFileEntity> __deleteAdapterOfEkoFileEntity;
    private final EntityDeleteOrUpdateAdapter<EkoFileEntity> __updateAdapterOfEkoFileEntity;

    public EkoFileDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertAdapterOfEkoFileEntity = new EntityInsertAdapter<EkoFileEntity>(){

            @NonNull
            protected String createQuery() {
                return "INSERT OR REPLACE INTO `file` (`fileId`,`fileUrl`,`filePath`,`type`,`accessType`,`attributes`,`altText`,`createdAt`,`updatedAt`,`expiresAt`) VALUES (?,?,?,?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull EkoFileEntity entity) {
                if (entity.getFileId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getFileId());
                }
                if (entity.getFileUrl() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindText(2, entity.getFileUrl());
                }
                if (entity.getFilePath() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindText(3, entity.getFilePath());
                }
                if (entity.getType() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindText(4, entity.getType());
                }
                if (entity.getAccessType() == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, entity.getAccessType());
                }
                String _tmp = EkoFileDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(entity.getAttributes());
                if (_tmp == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindText(6, _tmp);
                }
                if (entity.getAltText() == null) {
                    statement.bindNull(7);
                } else {
                    statement.bindText(7, entity.getAltText());
                }
                String _tmp_1 = EkoFileDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp_1 == null) {
                    statement.bindNull(8);
                } else {
                    statement.bindText(8, _tmp_1);
                }
                String _tmp_2 = EkoFileDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_2 == null) {
                    statement.bindNull(9);
                } else {
                    statement.bindText(9, _tmp_2);
                }
                String _tmp_3 = EkoFileDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_3 == null) {
                    statement.bindNull(10);
                } else {
                    statement.bindText(10, _tmp_3);
                }
            }
        };
        this.__deleteAdapterOfEkoFileEntity = new EntityDeleteOrUpdateAdapter<EkoFileEntity>(){

            @NonNull
            protected String createQuery() {
                return "DELETE FROM `file` WHERE `fileId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull EkoFileEntity entity) {
                if (entity.getFileId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getFileId());
                }
            }
        };
        this.__updateAdapterOfEkoFileEntity = new EntityDeleteOrUpdateAdapter<EkoFileEntity>(){

            @NonNull
            protected String createQuery() {
                return "UPDATE OR ABORT `file` SET `fileId` = ?,`fileUrl` = ?,`filePath` = ?,`type` = ?,`accessType` = ?,`attributes` = ?,`altText` = ?,`createdAt` = ?,`updatedAt` = ?,`expiresAt` = ? WHERE `fileId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull EkoFileEntity entity) {
                if (entity.getFileId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getFileId());
                }
                if (entity.getFileUrl() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindText(2, entity.getFileUrl());
                }
                if (entity.getFilePath() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindText(3, entity.getFilePath());
                }
                if (entity.getType() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindText(4, entity.getType());
                }
                if (entity.getAccessType() == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, entity.getAccessType());
                }
                String _tmp = EkoFileDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(entity.getAttributes());
                if (_tmp == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindText(6, _tmp);
                }
                if (entity.getAltText() == null) {
                    statement.bindNull(7);
                } else {
                    statement.bindText(7, entity.getAltText());
                }
                String _tmp_1 = EkoFileDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp_1 == null) {
                    statement.bindNull(8);
                } else {
                    statement.bindText(8, _tmp_1);
                }
                String _tmp_2 = EkoFileDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_2 == null) {
                    statement.bindNull(9);
                } else {
                    statement.bindText(9, _tmp_2);
                }
                String _tmp_3 = EkoFileDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_3 == null) {
                    statement.bindNull(10);
                } else {
                    statement.bindText(10, _tmp_3);
                }
                if (entity.getFileId() == null) {
                    statement.bindNull(11);
                } else {
                    statement.bindText(11, entity.getFileId());
                }
            }
        };
    }

    @Override
    public void insertImpl(EkoFileEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfEkoFileEntity.insert(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insertImpl(List<? extends EkoFileEntity> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfEkoFileEntity.insert(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void delete(EkoFileEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfEkoFileEntity.handle(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void delete(List<? extends EkoFileEntity> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfEkoFileEntity.handleMultiple(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void updateImpl(EkoFileEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__updateAdapterOfEkoFileEntity.handle(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insert(EkoFileEntity object) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            EkoFileDao_Impl.super.insert(object);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void insert(List<? extends EkoFileEntity> objects) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            EkoFileDao_Impl.super.insert(objects);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void update(EkoFileEntity object) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            EkoFileDao_Impl.super.update(object);
            return Unit.INSTANCE;
        });
    }

    @Override
    public Single<List<EkoFileEntity>> getByIdImpl(String fileId) {
        String _sql = "SELECT * from file where file.fileId = ? LIMIT 1";
        return RxRoom.createSingle((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from file where file.fileId = ? LIMIT 1");){
                int _argIndex = 1;
                if (fileId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, fileId);
                }
                int _columnIndexOfFileId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"fileId");
                int _columnIndexOfFileUrl = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"fileUrl");
                int _columnIndexOfFilePath = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"filePath");
                int _columnIndexOfType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"type");
                int _columnIndexOfAccessType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"accessType");
                int _columnIndexOfAttributes = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"attributes");
                int _columnIndexOfAltText = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"altText");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                ArrayList<EkoFileEntity> _result = new ArrayList<EkoFileEntity>();
                while (_stmt.step()) {
                    EkoFileEntity _item = new EkoFileEntity();
                    String _tmpFileId = _stmt.isNull(_columnIndexOfFileId) ? null : _stmt.getText(_columnIndexOfFileId);
                    _item.setFileId(_tmpFileId);
                    String _tmpFileUrl = _stmt.isNull(_columnIndexOfFileUrl) ? null : _stmt.getText(_columnIndexOfFileUrl);
                    _item.setFileUrl(_tmpFileUrl);
                    String _tmpFilePath = _stmt.isNull(_columnIndexOfFilePath) ? null : _stmt.getText(_columnIndexOfFilePath);
                    _item.setFilePath(_tmpFilePath);
                    String _tmpType = _stmt.isNull(_columnIndexOfType) ? null : _stmt.getText(_columnIndexOfType);
                    _item.setType(_tmpType);
                    String _tmpAccessType = _stmt.isNull(_columnIndexOfAccessType) ? null : _stmt.getText(_columnIndexOfAccessType);
                    _item.setAccessType(_tmpAccessType);
                    String _tmp = _stmt.isNull(_columnIndexOfAttributes) ? null : _stmt.getText(_columnIndexOfAttributes);
                    JsonObject _tmpAttributes = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp);
                    _item.setAttributes(_tmpAttributes);
                    String _tmpAltText = _stmt.isNull(_columnIndexOfAltText) ? null : _stmt.getText(_columnIndexOfAltText);
                    _item.setAltText(_tmpAltText);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                    _item.setCreatedAt(_tmpCreatedAt);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _item.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                    _item.setExpiresAt(_tmpExpiresAt);
                    _result.add(_item);
                }
                ArrayList<EkoFileEntity> arrayList = _result;
                return arrayList;
            }
        });
    }

    @Override
    public EkoFileEntity getByIdNowImpl(String fileId) {
        String _sql = "SELECT * from file where file.fileId = ? LIMIT 1";
        return (EkoFileEntity)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from file where file.fileId = ? LIMIT 1");){
                EkoFileEntity _result;
                int _argIndex = 1;
                if (fileId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, fileId);
                }
                int _columnIndexOfFileId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"fileId");
                int _columnIndexOfFileUrl = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"fileUrl");
                int _columnIndexOfFilePath = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"filePath");
                int _columnIndexOfType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"type");
                int _columnIndexOfAccessType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"accessType");
                int _columnIndexOfAttributes = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"attributes");
                int _columnIndexOfAltText = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"altText");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    _result = new EkoFileEntity();
                    String _tmpFileId = _stmt.isNull(_columnIndexOfFileId) ? null : _stmt.getText(_columnIndexOfFileId);
                    _result.setFileId(_tmpFileId);
                    String _tmpFileUrl = _stmt.isNull(_columnIndexOfFileUrl) ? null : _stmt.getText(_columnIndexOfFileUrl);
                    _result.setFileUrl(_tmpFileUrl);
                    String _tmpFilePath = _stmt.isNull(_columnIndexOfFilePath) ? null : _stmt.getText(_columnIndexOfFilePath);
                    _result.setFilePath(_tmpFilePath);
                    String _tmpType = _stmt.isNull(_columnIndexOfType) ? null : _stmt.getText(_columnIndexOfType);
                    _result.setType(_tmpType);
                    String _tmpAccessType = _stmt.isNull(_columnIndexOfAccessType) ? null : _stmt.getText(_columnIndexOfAccessType);
                    _result.setAccessType(_tmpAccessType);
                    String _tmp = _stmt.isNull(_columnIndexOfAttributes) ? null : _stmt.getText(_columnIndexOfAttributes);
                    JsonObject _tmpAttributes = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp);
                    _result.setAttributes(_tmpAttributes);
                    String _tmpAltText = _stmt.isNull(_columnIndexOfAltText) ? null : _stmt.getText(_columnIndexOfAltText);
                    _result.setAltText(_tmpAltText);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                EkoFileEntity ekoFileEntity = _result;
                return ekoFileEntity;
            }
        });
    }

    @Override
    public List<EkoFileEntity> getByIdsNowImpl(List<String> ids) {
        StringBuilder _stringBuilder = new StringBuilder();
        _stringBuilder.append("SELECT * from file where file.fileId IN (");
        int _inputSize = ids.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        return (List)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare(_sql);){
                int _argIndex = 1;
                for (String _item : ids) {
                    if (_item == null) {
                        _stmt.bindNull(_argIndex);
                    } else {
                        _stmt.bindText(_argIndex, _item);
                    }
                    ++_argIndex;
                }
                int _columnIndexOfFileId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"fileId");
                int _columnIndexOfFileUrl = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"fileUrl");
                int _columnIndexOfFilePath = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"filePath");
                int _columnIndexOfType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"type");
                int _columnIndexOfAccessType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"accessType");
                int _columnIndexOfAttributes = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"attributes");
                int _columnIndexOfAltText = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"altText");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                ArrayList<EkoFileEntity> _result = new ArrayList<EkoFileEntity>();
                while (_stmt.step()) {
                    EkoFileEntity _item_1 = new EkoFileEntity();
                    String _tmpFileId = _stmt.isNull(_columnIndexOfFileId) ? null : _stmt.getText(_columnIndexOfFileId);
                    _item_1.setFileId(_tmpFileId);
                    String _tmpFileUrl = _stmt.isNull(_columnIndexOfFileUrl) ? null : _stmt.getText(_columnIndexOfFileUrl);
                    _item_1.setFileUrl(_tmpFileUrl);
                    String _tmpFilePath = _stmt.isNull(_columnIndexOfFilePath) ? null : _stmt.getText(_columnIndexOfFilePath);
                    _item_1.setFilePath(_tmpFilePath);
                    String _tmpType = _stmt.isNull(_columnIndexOfType) ? null : _stmt.getText(_columnIndexOfType);
                    _item_1.setType(_tmpType);
                    String _tmpAccessType = _stmt.isNull(_columnIndexOfAccessType) ? null : _stmt.getText(_columnIndexOfAccessType);
                    _item_1.setAccessType(_tmpAccessType);
                    String _tmp = _stmt.isNull(_columnIndexOfAttributes) ? null : _stmt.getText(_columnIndexOfAttributes);
                    JsonObject _tmpAttributes = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp);
                    _item_1.setAttributes(_tmpAttributes);
                    String _tmpAltText = _stmt.isNull(_columnIndexOfAltText) ? null : _stmt.getText(_columnIndexOfAltText);
                    _item_1.setAltText(_tmpAltText);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                    _item_1.setCreatedAt(_tmpCreatedAt);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _item_1.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                    _item_1.setExpiresAt(_tmpExpiresAt);
                    _result.add(_item_1);
                }
                ArrayList<EkoFileEntity> arrayList = _result;
                return arrayList;
            }
        });
    }

    @Override
    public void deleteAll() {
        String _sql = "DELETE from file";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("DELETE from file");){
                _stmt.step();
                Object var2_2 = null;
                return var2_2;
            }
        });
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

