/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import androidx.annotation.NonNull;
import androidx.room.EntityDeleteOrUpdateAdapter;
import androidx.room.EntityInsertAdapter;
import androidx.room.RoomDatabase;
import androidx.room.rxjava3.RxRoom;
import androidx.room.util.DBUtil;
import androidx.room.util.SQLiteStatementUtil;
import androidx.sqlite.SQLiteStatement;
import com.ekoapp.ekosdk.internal.ChatSettingsEntity;
import com.ekoapp.ekosdk.internal.data.converter.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.data.dao.ChatSettingsDao;
import io.reactivex.rxjava3.core.Flowable;
import java.util.Collections;
import java.util.List;
import kotlin.Unit;
import org.joda.time.DateTime;

public final class ChatSettingsDao_Impl
extends ChatSettingsDao {
    private final RoomDatabase __db;
    private final EntityInsertAdapter<ChatSettingsEntity> __insertAdapterOfChatSettingsEntity;
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EntityDeleteOrUpdateAdapter<ChatSettingsEntity> __deleteAdapterOfChatSettingsEntity;
    private final EntityDeleteOrUpdateAdapter<ChatSettingsEntity> __updateAdapterOfChatSettingsEntity;

    public ChatSettingsDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertAdapterOfChatSettingsEntity = new EntityInsertAdapter<ChatSettingsEntity>(){

            @NonNull
            protected String createQuery() {
                return "INSERT OR REPLACE INTO `chat_settings` (`settingId`,`enabled`,`isAllowMentionedChannelEnabled`,`messagePreviewSetting`,`createdAt`,`updatedAt`,`expiresAt`) VALUES (?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull ChatSettingsEntity entity) {
                if (entity.getSettingId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getSettingId());
                }
                int _tmp = entity.getEnabled() ? 1 : 0;
                statement.bindLong(2, (long)_tmp);
                int _tmp_1 = entity.isAllowMentionedChannelEnabled() ? 1 : 0;
                statement.bindLong(3, (long)_tmp_1);
                if (entity.getMessagePreviewSetting() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindText(4, entity.getMessagePreviewSetting());
                }
                String _tmp_2 = ChatSettingsDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp_2 == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, _tmp_2);
                }
                String _tmp_3 = ChatSettingsDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_3 == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindText(6, _tmp_3);
                }
                String _tmp_4 = ChatSettingsDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_4 == null) {
                    statement.bindNull(7);
                } else {
                    statement.bindText(7, _tmp_4);
                }
            }
        };
        this.__deleteAdapterOfChatSettingsEntity = new EntityDeleteOrUpdateAdapter<ChatSettingsEntity>(){

            @NonNull
            protected String createQuery() {
                return "DELETE FROM `chat_settings` WHERE `settingId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull ChatSettingsEntity entity) {
                if (entity.getSettingId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getSettingId());
                }
            }
        };
        this.__updateAdapterOfChatSettingsEntity = new EntityDeleteOrUpdateAdapter<ChatSettingsEntity>(){

            @NonNull
            protected String createQuery() {
                return "UPDATE OR ABORT `chat_settings` SET `settingId` = ?,`enabled` = ?,`isAllowMentionedChannelEnabled` = ?,`messagePreviewSetting` = ?,`createdAt` = ?,`updatedAt` = ?,`expiresAt` = ? WHERE `settingId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull ChatSettingsEntity entity) {
                if (entity.getSettingId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getSettingId());
                }
                int _tmp = entity.getEnabled() ? 1 : 0;
                statement.bindLong(2, (long)_tmp);
                int _tmp_1 = entity.isAllowMentionedChannelEnabled() ? 1 : 0;
                statement.bindLong(3, (long)_tmp_1);
                if (entity.getMessagePreviewSetting() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindText(4, entity.getMessagePreviewSetting());
                }
                String _tmp_2 = ChatSettingsDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp_2 == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, _tmp_2);
                }
                String _tmp_3 = ChatSettingsDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_3 == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindText(6, _tmp_3);
                }
                String _tmp_4 = ChatSettingsDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_4 == null) {
                    statement.bindNull(7);
                } else {
                    statement.bindText(7, _tmp_4);
                }
                if (entity.getSettingId() == null) {
                    statement.bindNull(8);
                } else {
                    statement.bindText(8, entity.getSettingId());
                }
            }
        };
    }

    @Override
    public void insertImpl(ChatSettingsEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfChatSettingsEntity.insert(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insertImpl(List<? extends ChatSettingsEntity> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfChatSettingsEntity.insert(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void delete(ChatSettingsEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfChatSettingsEntity.handle(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void delete(List<? extends ChatSettingsEntity> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfChatSettingsEntity.handleMultiple(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void updateImpl(ChatSettingsEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__updateAdapterOfChatSettingsEntity.handle(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insert(ChatSettingsEntity object) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            ChatSettingsDao_Impl.super.insert(object);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void insert(List<? extends ChatSettingsEntity> objects) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            ChatSettingsDao_Impl.super.insert(objects);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void update(ChatSettingsEntity object) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            ChatSettingsDao_Impl.super.update(object);
            return Unit.INSTANCE;
        });
    }

    @Override
    public Flowable<ChatSettingsEntity> getChatSettings(String settingId) {
        String _sql = "select * from chat_settings where settingId = ?";
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"chat_settings"}, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("select * from chat_settings where settingId = ?");){
                ChatSettingsEntity _result;
                int _argIndex = 1;
                if (settingId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, settingId);
                }
                int _columnIndexOfSettingId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"settingId");
                int _columnIndexOfEnabled = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"enabled");
                int _columnIndexOfIsAllowMentionedChannelEnabled = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isAllowMentionedChannelEnabled");
                int _columnIndexOfMessagePreviewSetting = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"messagePreviewSetting");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    _result = new ChatSettingsEntity();
                    String _tmpSettingId = _stmt.isNull(_columnIndexOfSettingId) ? null : _stmt.getText(_columnIndexOfSettingId);
                    _result.setSettingId(_tmpSettingId);
                    int _tmp = (int)_stmt.getLong(_columnIndexOfEnabled);
                    boolean _tmpEnabled = _tmp != 0;
                    _result.setEnabled(_tmpEnabled);
                    int _tmp_1 = (int)_stmt.getLong(_columnIndexOfIsAllowMentionedChannelEnabled);
                    boolean _tmpIsAllowMentionedChannelEnabled = _tmp_1 != 0;
                    _result.setAllowMentionedChannelEnabled(_tmpIsAllowMentionedChannelEnabled);
                    String _tmpMessagePreviewSetting = _stmt.isNull(_columnIndexOfMessagePreviewSetting) ? null : _stmt.getText(_columnIndexOfMessagePreviewSetting);
                    _result.setMessagePreviewSetting(_tmpMessagePreviewSetting);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                ChatSettingsEntity chatSettingsEntity = _result;
                return chatSettingsEntity;
            }
        });
    }

    @Override
    public void deleteAll() {
        String _sql = "DELETE from chat_settings";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("DELETE from chat_settings");){
                _stmt.step();
                Object var2_2 = null;
                return var2_2;
            }
        });
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

