/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import androidx.annotation.NonNull;
import androidx.room.EntityDeleteOrUpdateAdapter;
import androidx.room.EntityInsertAdapter;
import androidx.room.RoomDatabase;
import androidx.room.rxjava3.RxRoom;
import androidx.room.util.DBUtil;
import androidx.room.util.SQLiteStatementUtil;
import androidx.sqlite.SQLiteStatement;
import com.ekoapp.ekosdk.internal.data.converter.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.JsonObjectTypeConverter;
import com.ekoapp.ekosdk.internal.data.dao.AnalyticsEventDao;
import com.ekoapp.ekosdk.internal.entity.AnalyticsEventEntity;
import com.google.gson.JsonObject;
import io.reactivex.rxjava3.core.Single;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kotlin.Unit;
import org.joda.time.DateTime;

public final class AnalyticsEventDao_Impl
extends AnalyticsEventDao {
    private final RoomDatabase __db;
    private final EntityInsertAdapter<AnalyticsEventEntity> __insertAdapterOfAnalyticsEventEntity;
    private final JsonObjectTypeConverter __jsonObjectTypeConverter = new JsonObjectTypeConverter();
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EntityDeleteOrUpdateAdapter<AnalyticsEventEntity> __deleteAdapterOfAnalyticsEventEntity;
    private final EntityDeleteOrUpdateAdapter<AnalyticsEventEntity> __updateAdapterOfAnalyticsEventEntity;

    public AnalyticsEventDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertAdapterOfAnalyticsEventEntity = new EntityInsertAdapter<AnalyticsEventEntity>(){

            @NonNull
            protected String createQuery() {
                return "INSERT OR REPLACE INTO `analytics_event` (`eventId`,`userId`,`contentId`,`contentType`,`activityType`,`metadata`,`deduplicationKey`,`syncPriority`,`createdAt`,`updatedAt`,`expiresAt`) VALUES (?,?,?,?,?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull AnalyticsEventEntity entity) {
                if (entity.getEventId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getEventId());
                }
                if (entity.getUserId() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindText(2, entity.getUserId());
                }
                if (entity.getContentId() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindText(3, entity.getContentId());
                }
                if (entity.getContentType() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindText(4, entity.getContentType());
                }
                if (entity.getActivityType() == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, entity.getActivityType());
                }
                String _tmp = AnalyticsEventDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(entity.getMetadata());
                if (_tmp == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindText(6, _tmp);
                }
                if (entity.getDeduplicationKey() == null) {
                    statement.bindNull(7);
                } else {
                    statement.bindText(7, entity.getDeduplicationKey());
                }
                if (entity.getSyncPriority() == null) {
                    statement.bindNull(8);
                } else {
                    statement.bindText(8, entity.getSyncPriority());
                }
                String _tmp_1 = AnalyticsEventDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp_1 == null) {
                    statement.bindNull(9);
                } else {
                    statement.bindText(9, _tmp_1);
                }
                String _tmp_2 = AnalyticsEventDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_2 == null) {
                    statement.bindNull(10);
                } else {
                    statement.bindText(10, _tmp_2);
                }
                String _tmp_3 = AnalyticsEventDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_3 == null) {
                    statement.bindNull(11);
                } else {
                    statement.bindText(11, _tmp_3);
                }
            }
        };
        this.__deleteAdapterOfAnalyticsEventEntity = new EntityDeleteOrUpdateAdapter<AnalyticsEventEntity>(){

            @NonNull
            protected String createQuery() {
                return "DELETE FROM `analytics_event` WHERE `eventId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull AnalyticsEventEntity entity) {
                if (entity.getEventId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getEventId());
                }
            }
        };
        this.__updateAdapterOfAnalyticsEventEntity = new EntityDeleteOrUpdateAdapter<AnalyticsEventEntity>(){

            @NonNull
            protected String createQuery() {
                return "UPDATE OR ABORT `analytics_event` SET `eventId` = ?,`userId` = ?,`contentId` = ?,`contentType` = ?,`activityType` = ?,`metadata` = ?,`deduplicationKey` = ?,`syncPriority` = ?,`createdAt` = ?,`updatedAt` = ?,`expiresAt` = ? WHERE `eventId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull AnalyticsEventEntity entity) {
                if (entity.getEventId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getEventId());
                }
                if (entity.getUserId() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindText(2, entity.getUserId());
                }
                if (entity.getContentId() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindText(3, entity.getContentId());
                }
                if (entity.getContentType() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindText(4, entity.getContentType());
                }
                if (entity.getActivityType() == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, entity.getActivityType());
                }
                String _tmp = AnalyticsEventDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(entity.getMetadata());
                if (_tmp == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindText(6, _tmp);
                }
                if (entity.getDeduplicationKey() == null) {
                    statement.bindNull(7);
                } else {
                    statement.bindText(7, entity.getDeduplicationKey());
                }
                if (entity.getSyncPriority() == null) {
                    statement.bindNull(8);
                } else {
                    statement.bindText(8, entity.getSyncPriority());
                }
                String _tmp_1 = AnalyticsEventDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp_1 == null) {
                    statement.bindNull(9);
                } else {
                    statement.bindText(9, _tmp_1);
                }
                String _tmp_2 = AnalyticsEventDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_2 == null) {
                    statement.bindNull(10);
                } else {
                    statement.bindText(10, _tmp_2);
                }
                String _tmp_3 = AnalyticsEventDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_3 == null) {
                    statement.bindNull(11);
                } else {
                    statement.bindText(11, _tmp_3);
                }
                if (entity.getEventId() == null) {
                    statement.bindNull(12);
                } else {
                    statement.bindText(12, entity.getEventId());
                }
            }
        };
    }

    @Override
    public void insertImpl(AnalyticsEventEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfAnalyticsEventEntity.insert(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insertImpl(List<? extends AnalyticsEventEntity> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfAnalyticsEventEntity.insert(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void delete(AnalyticsEventEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfAnalyticsEventEntity.handle(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void delete(List<? extends AnalyticsEventEntity> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfAnalyticsEventEntity.handleMultiple(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void updateImpl(AnalyticsEventEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__updateAdapterOfAnalyticsEventEntity.handle(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insert(AnalyticsEventEntity object) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            AnalyticsEventDao_Impl.super.insert(object);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void insert(List<? extends AnalyticsEventEntity> objects) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            AnalyticsEventDao_Impl.super.insert(objects);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void update(AnalyticsEventEntity object) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            AnalyticsEventDao_Impl.super.update(object);
            return Unit.INSTANCE;
        });
    }

    @Override
    public Single<List<AnalyticsEventEntity>> getAnalyticEvents(String userId, String syncPriority, int limit) {
        String _sql = "select * from analytics_event where userId =? and syncPriority = ? order by createdAt desc limit ?";
        return RxRoom.createSingle((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("select * from analytics_event where userId =? and syncPriority = ? order by createdAt desc limit ?");){
                int _argIndex = 1;
                if (userId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, userId);
                }
                _argIndex = 2;
                if (syncPriority == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, syncPriority);
                }
                _argIndex = 3;
                _stmt.bindLong(_argIndex, (long)limit);
                int _columnIndexOfEventId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"eventId");
                int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userId");
                int _columnIndexOfContentId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"contentId");
                int _columnIndexOfContentType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"contentType");
                int _columnIndexOfActivityType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"activityType");
                int _columnIndexOfMetadata = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"metadata");
                int _columnIndexOfDeduplicationKey = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"deduplicationKey");
                int _columnIndexOfSyncPriority = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"syncPriority");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                ArrayList<AnalyticsEventEntity> _result = new ArrayList<AnalyticsEventEntity>();
                while (_stmt.step()) {
                    String _tmpEventId = _stmt.isNull(_columnIndexOfEventId) ? null : _stmt.getText(_columnIndexOfEventId);
                    String _tmpUserId = _stmt.isNull(_columnIndexOfUserId) ? null : _stmt.getText(_columnIndexOfUserId);
                    String _tmpContentId = _stmt.isNull(_columnIndexOfContentId) ? null : _stmt.getText(_columnIndexOfContentId);
                    String _tmpContentType = _stmt.isNull(_columnIndexOfContentType) ? null : _stmt.getText(_columnIndexOfContentType);
                    String _tmpActivityType = _stmt.isNull(_columnIndexOfActivityType) ? null : _stmt.getText(_columnIndexOfActivityType);
                    String _tmp = _stmt.isNull(_columnIndexOfMetadata) ? null : _stmt.getText(_columnIndexOfMetadata);
                    JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp);
                    String _tmpDeduplicationKey = _stmt.isNull(_columnIndexOfDeduplicationKey) ? null : _stmt.getText(_columnIndexOfDeduplicationKey);
                    String _tmpSyncPriority = _stmt.isNull(_columnIndexOfSyncPriority) ? null : _stmt.getText(_columnIndexOfSyncPriority);
                    AnalyticsEventEntity _item = new AnalyticsEventEntity(_tmpEventId, _tmpUserId, _tmpContentId, _tmpContentType, _tmpActivityType, _tmpMetadata, _tmpDeduplicationKey, _tmpSyncPriority);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                    _item.setCreatedAt(_tmpCreatedAt);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _item.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                    _item.setExpiresAt(_tmpExpiresAt);
                    _result.add(_item);
                }
                ArrayList<AnalyticsEventEntity> arrayList = _result;
                return arrayList;
            }
        });
    }

    @Override
    public Single<Integer> getAnalyticEventsCount() {
        String _sql = "SELECT count(*) from analytics_event";
        return RxRoom.createSingle((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT count(*) from analytics_event");){
                Integer _result;
                if (_stmt.step()) {
                    Integer _tmp = _stmt.isNull(0) ? null : Integer.valueOf((int)_stmt.getLong(0));
                    _result = _tmp;
                } else {
                    _result = null;
                }
                Integer n = _result;
                return n;
            }
        });
    }

    @Override
    public AnalyticsEventEntity getByIdNowImpl(String id) {
        String _sql = "select * from analytics_event where userId = ? limit 1";
        return (AnalyticsEventEntity)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("select * from analytics_event where userId = ? limit 1");){
                AnalyticsEventEntity _result;
                int _argIndex = 1;
                if (id == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, id);
                }
                int _columnIndexOfEventId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"eventId");
                int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userId");
                int _columnIndexOfContentId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"contentId");
                int _columnIndexOfContentType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"contentType");
                int _columnIndexOfActivityType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"activityType");
                int _columnIndexOfMetadata = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"metadata");
                int _columnIndexOfDeduplicationKey = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"deduplicationKey");
                int _columnIndexOfSyncPriority = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"syncPriority");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    String _tmpEventId = _stmt.isNull(_columnIndexOfEventId) ? null : _stmt.getText(_columnIndexOfEventId);
                    String _tmpUserId = _stmt.isNull(_columnIndexOfUserId) ? null : _stmt.getText(_columnIndexOfUserId);
                    String _tmpContentId = _stmt.isNull(_columnIndexOfContentId) ? null : _stmt.getText(_columnIndexOfContentId);
                    String _tmpContentType = _stmt.isNull(_columnIndexOfContentType) ? null : _stmt.getText(_columnIndexOfContentType);
                    String _tmpActivityType = _stmt.isNull(_columnIndexOfActivityType) ? null : _stmt.getText(_columnIndexOfActivityType);
                    String _tmp = _stmt.isNull(_columnIndexOfMetadata) ? null : _stmt.getText(_columnIndexOfMetadata);
                    JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp);
                    String _tmpDeduplicationKey = _stmt.isNull(_columnIndexOfDeduplicationKey) ? null : _stmt.getText(_columnIndexOfDeduplicationKey);
                    String _tmpSyncPriority = _stmt.isNull(_columnIndexOfSyncPriority) ? null : _stmt.getText(_columnIndexOfSyncPriority);
                    _result = new AnalyticsEventEntity(_tmpEventId, _tmpUserId, _tmpContentId, _tmpContentType, _tmpActivityType, _tmpMetadata, _tmpDeduplicationKey, _tmpSyncPriority);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                AnalyticsEventEntity analyticsEventEntity = _result;
                return analyticsEventEntity;
            }
        });
    }

    @Override
    public void deleteAll() {
        String _sql = "DELETE from analytics_event";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("DELETE from analytics_event");){
                _stmt.step();
                Object var2_2 = null;
                return var2_2;
            }
        });
    }

    @Override
    public void deleteOldestEvent() {
        String _sql = "delete from analytics_event where eventId in (select eventId from analytics_event order by createdAt asc limit 1)";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("delete from analytics_event where eventId in (select eventId from analytics_event order by createdAt asc limit 1)");){
                _stmt.step();
                Object var2_2 = null;
                return var2_2;
            }
        });
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

