/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.video.data.stream;

import androidx.annotation.NonNull;
import androidx.room.EntityDeleteOrUpdateAdapter;
import androidx.room.EntityInsertAdapter;
import androidx.room.RoomDatabase;
import androidx.room.rxjava3.RxRoom;
import androidx.room.util.DBUtil;
import androidx.room.util.SQLiteStatementUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.SQLiteStatement;
import com.amity.socialcloud.sdk.entity.video.stream.EkoStreamEntity;
import com.amity.socialcloud.sdk.video.data.stream.EkoStreamDao;
import com.ekoapp.ekosdk.internal.data.converter.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.JsonArrayTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.JsonObjectTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.StringListConverter;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import io.reactivex.rxjava3.core.Flowable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kotlin.Unit;
import org.joda.time.DateTime;

public final class EkoStreamDao_Impl
extends EkoStreamDao {
    private final RoomDatabase __db;
    private final EntityInsertAdapter<EkoStreamEntity> __insertAdapterOfEkoStreamEntity;
    private final JsonObjectTypeConverter __jsonObjectTypeConverter = new JsonObjectTypeConverter();
    private final JsonArrayTypeConverter __jsonArrayTypeConverter = new JsonArrayTypeConverter();
    private final StringListConverter __stringListConverter = new StringListConverter();
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EntityDeleteOrUpdateAdapter<EkoStreamEntity> __deleteAdapterOfEkoStreamEntity;
    private final EntityDeleteOrUpdateAdapter<EkoStreamEntity> __updateAdapterOfEkoStreamEntity;

    public EkoStreamDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertAdapterOfEkoStreamEntity = new EntityInsertAdapter<EkoStreamEntity>(){

            @NonNull
            protected String createQuery() {
                return "INSERT OR REPLACE INTO `stream` (`streamId`,`moderationId`,`title`,`description`,`metadata`,`isDeleted`,`thumbnailFileId`,`userId`,`watcherData`,`broadcasterData`,`recordings`,`status`,`isReconnecting`,`resolution`,`referenceId`,`referenceType`,`targetId`,`targetType`,`postId`,`channelId`,`channelEnabled`,`isBanned`,`isParent`,`parentStreamId`,`childStreamIds`,`createdAt`,`updatedAt`,`expiresAt`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull EkoStreamEntity entity) {
                Integer _tmp_8;
                Integer _tmp_7;
                Integer _tmp_6;
                if (entity.getStreamId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getStreamId());
                }
                if (entity.getModerationId() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindText(2, entity.getModerationId());
                }
                if (entity.getTitle() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindText(3, entity.getTitle());
                }
                if (entity.getDescription() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindText(4, entity.getDescription());
                }
                String _tmp = EkoStreamDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(entity.getMetadata());
                if (_tmp == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, _tmp);
                }
                int _tmp_1 = entity.isDeleted() ? 1 : 0;
                statement.bindLong(6, (long)_tmp_1);
                if (entity.getThumbnailFileId() == null) {
                    statement.bindNull(7);
                } else {
                    statement.bindText(7, entity.getThumbnailFileId());
                }
                if (entity.getUserId() == null) {
                    statement.bindNull(8);
                } else {
                    statement.bindText(8, entity.getUserId());
                }
                String _tmp_2 = EkoStreamDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(entity.getWatcherData());
                if (_tmp_2 == null) {
                    statement.bindNull(9);
                } else {
                    statement.bindText(9, _tmp_2);
                }
                String _tmp_3 = EkoStreamDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(entity.getBroadcasterData());
                if (_tmp_3 == null) {
                    statement.bindNull(10);
                } else {
                    statement.bindText(10, _tmp_3);
                }
                String _tmp_4 = EkoStreamDao_Impl.this.__jsonArrayTypeConverter.jsonObjectToString(entity.getRecordings());
                if (_tmp_4 == null) {
                    statement.bindNull(11);
                } else {
                    statement.bindText(11, _tmp_4);
                }
                if (entity.getStatus() == null) {
                    statement.bindNull(12);
                } else {
                    statement.bindText(12, entity.getStatus());
                }
                int _tmp_5 = entity.isReconnecting() ? 1 : 0;
                statement.bindLong(13, (long)_tmp_5);
                if (entity.getResolution() == null) {
                    statement.bindNull(14);
                } else {
                    statement.bindText(14, entity.getResolution());
                }
                if (entity.getReferenceId() == null) {
                    statement.bindNull(15);
                } else {
                    statement.bindText(15, entity.getReferenceId());
                }
                if (entity.getReferenceType() == null) {
                    statement.bindNull(16);
                } else {
                    statement.bindText(16, entity.getReferenceType());
                }
                if (entity.getTargetId() == null) {
                    statement.bindNull(17);
                } else {
                    statement.bindText(17, entity.getTargetId());
                }
                if (entity.getTargetType() == null) {
                    statement.bindNull(18);
                } else {
                    statement.bindText(18, entity.getTargetType());
                }
                if (entity.getPostId() == null) {
                    statement.bindNull(19);
                } else {
                    statement.bindText(19, entity.getPostId());
                }
                if (entity.getChannelId() == null) {
                    statement.bindNull(20);
                } else {
                    statement.bindText(20, entity.getChannelId());
                }
                Integer n = entity.getChannelEnabled() == null ? null : (_tmp_6 = Integer.valueOf(entity.getChannelEnabled() != false ? 1 : 0));
                if (_tmp_6 == null) {
                    statement.bindNull(21);
                } else {
                    statement.bindLong(21, (long)_tmp_6.intValue());
                }
                Integer n2 = entity.isBanned() == null ? null : (_tmp_7 = Integer.valueOf(entity.isBanned() != false ? 1 : 0));
                if (_tmp_7 == null) {
                    statement.bindNull(22);
                } else {
                    statement.bindLong(22, (long)_tmp_7.intValue());
                }
                Integer n3 = entity.isParent() == null ? null : (_tmp_8 = Integer.valueOf(entity.isParent() != false ? 1 : 0));
                if (_tmp_8 == null) {
                    statement.bindNull(23);
                } else {
                    statement.bindLong(23, (long)_tmp_8.intValue());
                }
                if (entity.getParentStreamId() == null) {
                    statement.bindNull(24);
                } else {
                    statement.bindText(24, entity.getParentStreamId());
                }
                String _tmp_9 = EkoStreamDao_Impl.this.__stringListConverter.stringListToString(entity.getChildStreamIds());
                if (_tmp_9 == null) {
                    statement.bindNull(25);
                } else {
                    statement.bindText(25, _tmp_9);
                }
                String _tmp_10 = EkoStreamDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp_10 == null) {
                    statement.bindNull(26);
                } else {
                    statement.bindText(26, _tmp_10);
                }
                String _tmp_11 = EkoStreamDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_11 == null) {
                    statement.bindNull(27);
                } else {
                    statement.bindText(27, _tmp_11);
                }
                String _tmp_12 = EkoStreamDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_12 == null) {
                    statement.bindNull(28);
                } else {
                    statement.bindText(28, _tmp_12);
                }
            }
        };
        this.__deleteAdapterOfEkoStreamEntity = new EntityDeleteOrUpdateAdapter<EkoStreamEntity>(){

            @NonNull
            protected String createQuery() {
                return "DELETE FROM `stream` WHERE `streamId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull EkoStreamEntity entity) {
                if (entity.getStreamId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getStreamId());
                }
            }
        };
        this.__updateAdapterOfEkoStreamEntity = new EntityDeleteOrUpdateAdapter<EkoStreamEntity>(){

            @NonNull
            protected String createQuery() {
                return "UPDATE OR ABORT `stream` SET `streamId` = ?,`moderationId` = ?,`title` = ?,`description` = ?,`metadata` = ?,`isDeleted` = ?,`thumbnailFileId` = ?,`userId` = ?,`watcherData` = ?,`broadcasterData` = ?,`recordings` = ?,`status` = ?,`isReconnecting` = ?,`resolution` = ?,`referenceId` = ?,`referenceType` = ?,`targetId` = ?,`targetType` = ?,`postId` = ?,`channelId` = ?,`channelEnabled` = ?,`isBanned` = ?,`isParent` = ?,`parentStreamId` = ?,`childStreamIds` = ?,`createdAt` = ?,`updatedAt` = ?,`expiresAt` = ? WHERE `streamId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull EkoStreamEntity entity) {
                Integer _tmp_8;
                Integer _tmp_7;
                Integer _tmp_6;
                if (entity.getStreamId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getStreamId());
                }
                if (entity.getModerationId() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindText(2, entity.getModerationId());
                }
                if (entity.getTitle() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindText(3, entity.getTitle());
                }
                if (entity.getDescription() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindText(4, entity.getDescription());
                }
                String _tmp = EkoStreamDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(entity.getMetadata());
                if (_tmp == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, _tmp);
                }
                int _tmp_1 = entity.isDeleted() ? 1 : 0;
                statement.bindLong(6, (long)_tmp_1);
                if (entity.getThumbnailFileId() == null) {
                    statement.bindNull(7);
                } else {
                    statement.bindText(7, entity.getThumbnailFileId());
                }
                if (entity.getUserId() == null) {
                    statement.bindNull(8);
                } else {
                    statement.bindText(8, entity.getUserId());
                }
                String _tmp_2 = EkoStreamDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(entity.getWatcherData());
                if (_tmp_2 == null) {
                    statement.bindNull(9);
                } else {
                    statement.bindText(9, _tmp_2);
                }
                String _tmp_3 = EkoStreamDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(entity.getBroadcasterData());
                if (_tmp_3 == null) {
                    statement.bindNull(10);
                } else {
                    statement.bindText(10, _tmp_3);
                }
                String _tmp_4 = EkoStreamDao_Impl.this.__jsonArrayTypeConverter.jsonObjectToString(entity.getRecordings());
                if (_tmp_4 == null) {
                    statement.bindNull(11);
                } else {
                    statement.bindText(11, _tmp_4);
                }
                if (entity.getStatus() == null) {
                    statement.bindNull(12);
                } else {
                    statement.bindText(12, entity.getStatus());
                }
                int _tmp_5 = entity.isReconnecting() ? 1 : 0;
                statement.bindLong(13, (long)_tmp_5);
                if (entity.getResolution() == null) {
                    statement.bindNull(14);
                } else {
                    statement.bindText(14, entity.getResolution());
                }
                if (entity.getReferenceId() == null) {
                    statement.bindNull(15);
                } else {
                    statement.bindText(15, entity.getReferenceId());
                }
                if (entity.getReferenceType() == null) {
                    statement.bindNull(16);
                } else {
                    statement.bindText(16, entity.getReferenceType());
                }
                if (entity.getTargetId() == null) {
                    statement.bindNull(17);
                } else {
                    statement.bindText(17, entity.getTargetId());
                }
                if (entity.getTargetType() == null) {
                    statement.bindNull(18);
                } else {
                    statement.bindText(18, entity.getTargetType());
                }
                if (entity.getPostId() == null) {
                    statement.bindNull(19);
                } else {
                    statement.bindText(19, entity.getPostId());
                }
                if (entity.getChannelId() == null) {
                    statement.bindNull(20);
                } else {
                    statement.bindText(20, entity.getChannelId());
                }
                Integer n = entity.getChannelEnabled() == null ? null : (_tmp_6 = Integer.valueOf(entity.getChannelEnabled() != false ? 1 : 0));
                if (_tmp_6 == null) {
                    statement.bindNull(21);
                } else {
                    statement.bindLong(21, (long)_tmp_6.intValue());
                }
                Integer n2 = entity.isBanned() == null ? null : (_tmp_7 = Integer.valueOf(entity.isBanned() != false ? 1 : 0));
                if (_tmp_7 == null) {
                    statement.bindNull(22);
                } else {
                    statement.bindLong(22, (long)_tmp_7.intValue());
                }
                Integer n3 = entity.isParent() == null ? null : (_tmp_8 = Integer.valueOf(entity.isParent() != false ? 1 : 0));
                if (_tmp_8 == null) {
                    statement.bindNull(23);
                } else {
                    statement.bindLong(23, (long)_tmp_8.intValue());
                }
                if (entity.getParentStreamId() == null) {
                    statement.bindNull(24);
                } else {
                    statement.bindText(24, entity.getParentStreamId());
                }
                String _tmp_9 = EkoStreamDao_Impl.this.__stringListConverter.stringListToString(entity.getChildStreamIds());
                if (_tmp_9 == null) {
                    statement.bindNull(25);
                } else {
                    statement.bindText(25, _tmp_9);
                }
                String _tmp_10 = EkoStreamDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp_10 == null) {
                    statement.bindNull(26);
                } else {
                    statement.bindText(26, _tmp_10);
                }
                String _tmp_11 = EkoStreamDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_11 == null) {
                    statement.bindNull(27);
                } else {
                    statement.bindText(27, _tmp_11);
                }
                String _tmp_12 = EkoStreamDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_12 == null) {
                    statement.bindNull(28);
                } else {
                    statement.bindText(28, _tmp_12);
                }
                if (entity.getStreamId() == null) {
                    statement.bindNull(29);
                } else {
                    statement.bindText(29, entity.getStreamId());
                }
            }
        };
    }

    @Override
    public void insertImpl(EkoStreamEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfEkoStreamEntity.insert(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insertImpl(List<? extends EkoStreamEntity> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfEkoStreamEntity.insert(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void delete(EkoStreamEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfEkoStreamEntity.handle(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void delete(List<? extends EkoStreamEntity> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfEkoStreamEntity.handleMultiple(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void updateImpl(EkoStreamEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__updateAdapterOfEkoStreamEntity.handle(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insert(EkoStreamEntity object) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            EkoStreamDao_Impl.super.insert(object);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void insert(List<? extends EkoStreamEntity> objects) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            EkoStreamDao_Impl.super.insert(objects);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void update(EkoStreamEntity object) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            EkoStreamDao_Impl.super.update(object);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void softDelete() {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            EkoStreamDao_Impl.super.softDelete();
            return Unit.INSTANCE;
        });
    }

    @Override
    public void updateStream(String streamId) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            EkoStreamDao_Impl.super.updateStream(streamId);
            return Unit.INSTANCE;
        });
    }

    @Override
    public Flowable<EkoStreamEntity> getByIdImpl(String streamId) {
        String _sql = "SELECT * from stream where streamId = ?";
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"stream"}, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from stream where streamId = ?");){
                EkoStreamEntity _result;
                int _argIndex = 1;
                if (streamId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, streamId);
                }
                int _columnIndexOfStreamId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"streamId");
                int _columnIndexOfModerationId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"moderationId");
                int _columnIndexOfTitle = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"title");
                int _columnIndexOfDescription = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"description");
                int _columnIndexOfMetadata = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"metadata");
                int _columnIndexOfIsDeleted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isDeleted");
                int _columnIndexOfThumbnailFileId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"thumbnailFileId");
                int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userId");
                int _columnIndexOfWatcherData = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"watcherData");
                int _columnIndexOfBroadcasterData = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"broadcasterData");
                int _columnIndexOfRecordings = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"recordings");
                int _columnIndexOfStatus = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"status");
                int _columnIndexOfIsReconnecting = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isReconnecting");
                int _columnIndexOfResolution = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"resolution");
                int _columnIndexOfReferenceId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"referenceId");
                int _columnIndexOfReferenceType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"referenceType");
                int _columnIndexOfTargetId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetId");
                int _columnIndexOfTargetType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetType");
                int _columnIndexOfPostId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"postId");
                int _columnIndexOfChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelId");
                int _columnIndexOfChannelEnabled = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelEnabled");
                int _columnIndexOfIsBanned = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isBanned");
                int _columnIndexOfIsParent = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isParent");
                int _columnIndexOfParentStreamId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"parentStreamId");
                int _columnIndexOfChildStreamIds = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"childStreamIds");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    _result = new EkoStreamEntity();
                    String _tmpStreamId = _stmt.isNull(_columnIndexOfStreamId) ? null : _stmt.getText(_columnIndexOfStreamId);
                    _result.setStreamId(_tmpStreamId);
                    String _tmpModerationId = _stmt.isNull(_columnIndexOfModerationId) ? null : _stmt.getText(_columnIndexOfModerationId);
                    _result.setModerationId(_tmpModerationId);
                    String _tmpTitle = _stmt.isNull(_columnIndexOfTitle) ? null : _stmt.getText(_columnIndexOfTitle);
                    _result.setTitle(_tmpTitle);
                    String _tmpDescription = _stmt.isNull(_columnIndexOfDescription) ? null : _stmt.getText(_columnIndexOfDescription);
                    _result.setDescription(_tmpDescription);
                    String _tmp = _stmt.isNull(_columnIndexOfMetadata) ? null : _stmt.getText(_columnIndexOfMetadata);
                    JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp);
                    _result.setMetadata(_tmpMetadata);
                    int _tmp_1 = (int)_stmt.getLong(_columnIndexOfIsDeleted);
                    boolean _tmpIsDeleted = _tmp_1 != 0;
                    _result.setDeleted(_tmpIsDeleted);
                    String _tmpThumbnailFileId = _stmt.isNull(_columnIndexOfThumbnailFileId) ? null : _stmt.getText(_columnIndexOfThumbnailFileId);
                    _result.setThumbnailFileId(_tmpThumbnailFileId);
                    String _tmpUserId = _stmt.isNull(_columnIndexOfUserId) ? null : _stmt.getText(_columnIndexOfUserId);
                    _result.setUserId(_tmpUserId);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfWatcherData) ? null : _stmt.getText(_columnIndexOfWatcherData);
                    JsonObject _tmpWatcherData = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_2);
                    _result.setWatcherData(_tmpWatcherData);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfBroadcasterData) ? null : _stmt.getText(_columnIndexOfBroadcasterData);
                    JsonObject _tmpBroadcasterData = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_3);
                    _result.setBroadcasterData(_tmpBroadcasterData);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfRecordings) ? null : _stmt.getText(_columnIndexOfRecordings);
                    JsonArray _tmpRecordings = this.__jsonArrayTypeConverter.stringToJsonObject(_tmp_4);
                    _result.setRecordings(_tmpRecordings);
                    String _tmpStatus = _stmt.isNull(_columnIndexOfStatus) ? null : _stmt.getText(_columnIndexOfStatus);
                    _result.setStatus(_tmpStatus);
                    int _tmp_5 = (int)_stmt.getLong(_columnIndexOfIsReconnecting);
                    boolean _tmpIsReconnecting = _tmp_5 != 0;
                    _result.setReconnecting(_tmpIsReconnecting);
                    String _tmpResolution = _stmt.isNull(_columnIndexOfResolution) ? null : _stmt.getText(_columnIndexOfResolution);
                    _result.setResolution(_tmpResolution);
                    String _tmpReferenceId = _stmt.isNull(_columnIndexOfReferenceId) ? null : _stmt.getText(_columnIndexOfReferenceId);
                    _result.setReferenceId(_tmpReferenceId);
                    String _tmpReferenceType = _stmt.isNull(_columnIndexOfReferenceType) ? null : _stmt.getText(_columnIndexOfReferenceType);
                    _result.setReferenceType(_tmpReferenceType);
                    String _tmpTargetId = _stmt.isNull(_columnIndexOfTargetId) ? null : _stmt.getText(_columnIndexOfTargetId);
                    _result.setTargetId(_tmpTargetId);
                    String _tmpTargetType = _stmt.isNull(_columnIndexOfTargetType) ? null : _stmt.getText(_columnIndexOfTargetType);
                    _result.setTargetType(_tmpTargetType);
                    String _tmpPostId = _stmt.isNull(_columnIndexOfPostId) ? null : _stmt.getText(_columnIndexOfPostId);
                    _result.setPostId(_tmpPostId);
                    String _tmpChannelId = _stmt.isNull(_columnIndexOfChannelId) ? null : _stmt.getText(_columnIndexOfChannelId);
                    _result.setChannelId(_tmpChannelId);
                    Integer _tmp_6 = _stmt.isNull(_columnIndexOfChannelEnabled) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfChannelEnabled));
                    Boolean _tmpChannelEnabled = _tmp_6 == null ? null : Boolean.valueOf(_tmp_6 != 0);
                    _result.setChannelEnabled(_tmpChannelEnabled);
                    Integer _tmp_7 = _stmt.isNull(_columnIndexOfIsBanned) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfIsBanned));
                    Boolean _tmpIsBanned = _tmp_7 == null ? null : Boolean.valueOf(_tmp_7 != 0);
                    _result.setBanned(_tmpIsBanned);
                    Integer _tmp_8 = _stmt.isNull(_columnIndexOfIsParent) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfIsParent));
                    Boolean _tmpIsParent = _tmp_8 == null ? null : Boolean.valueOf(_tmp_8 != 0);
                    _result.setParent(_tmpIsParent);
                    String _tmpParentStreamId = _stmt.isNull(_columnIndexOfParentStreamId) ? null : _stmt.getText(_columnIndexOfParentStreamId);
                    _result.setParentStreamId(_tmpParentStreamId);
                    String _tmp_9 = _stmt.isNull(_columnIndexOfChildStreamIds) ? null : _stmt.getText(_columnIndexOfChildStreamIds);
                    List<String> _tmpChildStreamIds = this.__stringListConverter.stringToStringList(_tmp_9);
                    _result.setChildStreamIds(_tmpChildStreamIds);
                    String _tmp_10 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_10);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_11 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_11);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_12 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_12);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                EkoStreamEntity ekoStreamEntity = _result;
                return ekoStreamEntity;
            }
        });
    }

    @Override
    public EkoStreamEntity getByIdNowImpl(String streamId) {
        String _sql = "SELECT * from stream where streamId = ?";
        return (EkoStreamEntity)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from stream where streamId = ?");){
                EkoStreamEntity _result;
                int _argIndex = 1;
                if (streamId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, streamId);
                }
                int _columnIndexOfStreamId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"streamId");
                int _columnIndexOfModerationId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"moderationId");
                int _columnIndexOfTitle = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"title");
                int _columnIndexOfDescription = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"description");
                int _columnIndexOfMetadata = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"metadata");
                int _columnIndexOfIsDeleted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isDeleted");
                int _columnIndexOfThumbnailFileId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"thumbnailFileId");
                int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userId");
                int _columnIndexOfWatcherData = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"watcherData");
                int _columnIndexOfBroadcasterData = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"broadcasterData");
                int _columnIndexOfRecordings = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"recordings");
                int _columnIndexOfStatus = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"status");
                int _columnIndexOfIsReconnecting = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isReconnecting");
                int _columnIndexOfResolution = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"resolution");
                int _columnIndexOfReferenceId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"referenceId");
                int _columnIndexOfReferenceType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"referenceType");
                int _columnIndexOfTargetId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetId");
                int _columnIndexOfTargetType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetType");
                int _columnIndexOfPostId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"postId");
                int _columnIndexOfChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelId");
                int _columnIndexOfChannelEnabled = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelEnabled");
                int _columnIndexOfIsBanned = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isBanned");
                int _columnIndexOfIsParent = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isParent");
                int _columnIndexOfParentStreamId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"parentStreamId");
                int _columnIndexOfChildStreamIds = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"childStreamIds");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    _result = new EkoStreamEntity();
                    String _tmpStreamId = _stmt.isNull(_columnIndexOfStreamId) ? null : _stmt.getText(_columnIndexOfStreamId);
                    _result.setStreamId(_tmpStreamId);
                    String _tmpModerationId = _stmt.isNull(_columnIndexOfModerationId) ? null : _stmt.getText(_columnIndexOfModerationId);
                    _result.setModerationId(_tmpModerationId);
                    String _tmpTitle = _stmt.isNull(_columnIndexOfTitle) ? null : _stmt.getText(_columnIndexOfTitle);
                    _result.setTitle(_tmpTitle);
                    String _tmpDescription = _stmt.isNull(_columnIndexOfDescription) ? null : _stmt.getText(_columnIndexOfDescription);
                    _result.setDescription(_tmpDescription);
                    String _tmp = _stmt.isNull(_columnIndexOfMetadata) ? null : _stmt.getText(_columnIndexOfMetadata);
                    JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp);
                    _result.setMetadata(_tmpMetadata);
                    int _tmp_1 = (int)_stmt.getLong(_columnIndexOfIsDeleted);
                    boolean _tmpIsDeleted = _tmp_1 != 0;
                    _result.setDeleted(_tmpIsDeleted);
                    String _tmpThumbnailFileId = _stmt.isNull(_columnIndexOfThumbnailFileId) ? null : _stmt.getText(_columnIndexOfThumbnailFileId);
                    _result.setThumbnailFileId(_tmpThumbnailFileId);
                    String _tmpUserId = _stmt.isNull(_columnIndexOfUserId) ? null : _stmt.getText(_columnIndexOfUserId);
                    _result.setUserId(_tmpUserId);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfWatcherData) ? null : _stmt.getText(_columnIndexOfWatcherData);
                    JsonObject _tmpWatcherData = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_2);
                    _result.setWatcherData(_tmpWatcherData);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfBroadcasterData) ? null : _stmt.getText(_columnIndexOfBroadcasterData);
                    JsonObject _tmpBroadcasterData = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_3);
                    _result.setBroadcasterData(_tmpBroadcasterData);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfRecordings) ? null : _stmt.getText(_columnIndexOfRecordings);
                    JsonArray _tmpRecordings = this.__jsonArrayTypeConverter.stringToJsonObject(_tmp_4);
                    _result.setRecordings(_tmpRecordings);
                    String _tmpStatus = _stmt.isNull(_columnIndexOfStatus) ? null : _stmt.getText(_columnIndexOfStatus);
                    _result.setStatus(_tmpStatus);
                    int _tmp_5 = (int)_stmt.getLong(_columnIndexOfIsReconnecting);
                    boolean _tmpIsReconnecting = _tmp_5 != 0;
                    _result.setReconnecting(_tmpIsReconnecting);
                    String _tmpResolution = _stmt.isNull(_columnIndexOfResolution) ? null : _stmt.getText(_columnIndexOfResolution);
                    _result.setResolution(_tmpResolution);
                    String _tmpReferenceId = _stmt.isNull(_columnIndexOfReferenceId) ? null : _stmt.getText(_columnIndexOfReferenceId);
                    _result.setReferenceId(_tmpReferenceId);
                    String _tmpReferenceType = _stmt.isNull(_columnIndexOfReferenceType) ? null : _stmt.getText(_columnIndexOfReferenceType);
                    _result.setReferenceType(_tmpReferenceType);
                    String _tmpTargetId = _stmt.isNull(_columnIndexOfTargetId) ? null : _stmt.getText(_columnIndexOfTargetId);
                    _result.setTargetId(_tmpTargetId);
                    String _tmpTargetType = _stmt.isNull(_columnIndexOfTargetType) ? null : _stmt.getText(_columnIndexOfTargetType);
                    _result.setTargetType(_tmpTargetType);
                    String _tmpPostId = _stmt.isNull(_columnIndexOfPostId) ? null : _stmt.getText(_columnIndexOfPostId);
                    _result.setPostId(_tmpPostId);
                    String _tmpChannelId = _stmt.isNull(_columnIndexOfChannelId) ? null : _stmt.getText(_columnIndexOfChannelId);
                    _result.setChannelId(_tmpChannelId);
                    Integer _tmp_6 = _stmt.isNull(_columnIndexOfChannelEnabled) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfChannelEnabled));
                    Boolean _tmpChannelEnabled = _tmp_6 == null ? null : Boolean.valueOf(_tmp_6 != 0);
                    _result.setChannelEnabled(_tmpChannelEnabled);
                    Integer _tmp_7 = _stmt.isNull(_columnIndexOfIsBanned) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfIsBanned));
                    Boolean _tmpIsBanned = _tmp_7 == null ? null : Boolean.valueOf(_tmp_7 != 0);
                    _result.setBanned(_tmpIsBanned);
                    Integer _tmp_8 = _stmt.isNull(_columnIndexOfIsParent) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfIsParent));
                    Boolean _tmpIsParent = _tmp_8 == null ? null : Boolean.valueOf(_tmp_8 != 0);
                    _result.setParent(_tmpIsParent);
                    String _tmpParentStreamId = _stmt.isNull(_columnIndexOfParentStreamId) ? null : _stmt.getText(_columnIndexOfParentStreamId);
                    _result.setParentStreamId(_tmpParentStreamId);
                    String _tmp_9 = _stmt.isNull(_columnIndexOfChildStreamIds) ? null : _stmt.getText(_columnIndexOfChildStreamIds);
                    List<String> _tmpChildStreamIds = this.__stringListConverter.stringToStringList(_tmp_9);
                    _result.setChildStreamIds(_tmpChildStreamIds);
                    String _tmp_10 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_10);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_11 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_11);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_12 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_12);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                EkoStreamEntity ekoStreamEntity = _result;
                return ekoStreamEntity;
            }
        });
    }

    @Override
    public List<EkoStreamEntity> getByIdsNowImpl(List<String> streamIds) {
        StringBuilder _stringBuilder = new StringBuilder();
        _stringBuilder.append("SELECT * from stream where streamId  in (");
        int _inputSize = streamIds.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        return (List)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare(_sql);){
                int _argIndex = 1;
                for (String _item : streamIds) {
                    if (_item == null) {
                        _stmt.bindNull(_argIndex);
                    } else {
                        _stmt.bindText(_argIndex, _item);
                    }
                    ++_argIndex;
                }
                int _columnIndexOfStreamId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"streamId");
                int _columnIndexOfModerationId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"moderationId");
                int _columnIndexOfTitle = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"title");
                int _columnIndexOfDescription = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"description");
                int _columnIndexOfMetadata = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"metadata");
                int _columnIndexOfIsDeleted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isDeleted");
                int _columnIndexOfThumbnailFileId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"thumbnailFileId");
                int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userId");
                int _columnIndexOfWatcherData = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"watcherData");
                int _columnIndexOfBroadcasterData = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"broadcasterData");
                int _columnIndexOfRecordings = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"recordings");
                int _columnIndexOfStatus = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"status");
                int _columnIndexOfIsReconnecting = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isReconnecting");
                int _columnIndexOfResolution = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"resolution");
                int _columnIndexOfReferenceId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"referenceId");
                int _columnIndexOfReferenceType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"referenceType");
                int _columnIndexOfTargetId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetId");
                int _columnIndexOfTargetType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetType");
                int _columnIndexOfPostId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"postId");
                int _columnIndexOfChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelId");
                int _columnIndexOfChannelEnabled = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelEnabled");
                int _columnIndexOfIsBanned = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isBanned");
                int _columnIndexOfIsParent = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isParent");
                int _columnIndexOfParentStreamId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"parentStreamId");
                int _columnIndexOfChildStreamIds = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"childStreamIds");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                ArrayList<EkoStreamEntity> _result = new ArrayList<EkoStreamEntity>();
                while (_stmt.step()) {
                    EkoStreamEntity _item_1 = new EkoStreamEntity();
                    String _tmpStreamId = _stmt.isNull(_columnIndexOfStreamId) ? null : _stmt.getText(_columnIndexOfStreamId);
                    _item_1.setStreamId(_tmpStreamId);
                    String _tmpModerationId = _stmt.isNull(_columnIndexOfModerationId) ? null : _stmt.getText(_columnIndexOfModerationId);
                    _item_1.setModerationId(_tmpModerationId);
                    String _tmpTitle = _stmt.isNull(_columnIndexOfTitle) ? null : _stmt.getText(_columnIndexOfTitle);
                    _item_1.setTitle(_tmpTitle);
                    String _tmpDescription = _stmt.isNull(_columnIndexOfDescription) ? null : _stmt.getText(_columnIndexOfDescription);
                    _item_1.setDescription(_tmpDescription);
                    String _tmp = _stmt.isNull(_columnIndexOfMetadata) ? null : _stmt.getText(_columnIndexOfMetadata);
                    JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp);
                    _item_1.setMetadata(_tmpMetadata);
                    int _tmp_1 = (int)_stmt.getLong(_columnIndexOfIsDeleted);
                    boolean _tmpIsDeleted = _tmp_1 != 0;
                    _item_1.setDeleted(_tmpIsDeleted);
                    String _tmpThumbnailFileId = _stmt.isNull(_columnIndexOfThumbnailFileId) ? null : _stmt.getText(_columnIndexOfThumbnailFileId);
                    _item_1.setThumbnailFileId(_tmpThumbnailFileId);
                    String _tmpUserId = _stmt.isNull(_columnIndexOfUserId) ? null : _stmt.getText(_columnIndexOfUserId);
                    _item_1.setUserId(_tmpUserId);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfWatcherData) ? null : _stmt.getText(_columnIndexOfWatcherData);
                    JsonObject _tmpWatcherData = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_2);
                    _item_1.setWatcherData(_tmpWatcherData);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfBroadcasterData) ? null : _stmt.getText(_columnIndexOfBroadcasterData);
                    JsonObject _tmpBroadcasterData = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_3);
                    _item_1.setBroadcasterData(_tmpBroadcasterData);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfRecordings) ? null : _stmt.getText(_columnIndexOfRecordings);
                    JsonArray _tmpRecordings = this.__jsonArrayTypeConverter.stringToJsonObject(_tmp_4);
                    _item_1.setRecordings(_tmpRecordings);
                    String _tmpStatus = _stmt.isNull(_columnIndexOfStatus) ? null : _stmt.getText(_columnIndexOfStatus);
                    _item_1.setStatus(_tmpStatus);
                    int _tmp_5 = (int)_stmt.getLong(_columnIndexOfIsReconnecting);
                    boolean _tmpIsReconnecting = _tmp_5 != 0;
                    _item_1.setReconnecting(_tmpIsReconnecting);
                    String _tmpResolution = _stmt.isNull(_columnIndexOfResolution) ? null : _stmt.getText(_columnIndexOfResolution);
                    _item_1.setResolution(_tmpResolution);
                    String _tmpReferenceId = _stmt.isNull(_columnIndexOfReferenceId) ? null : _stmt.getText(_columnIndexOfReferenceId);
                    _item_1.setReferenceId(_tmpReferenceId);
                    String _tmpReferenceType = _stmt.isNull(_columnIndexOfReferenceType) ? null : _stmt.getText(_columnIndexOfReferenceType);
                    _item_1.setReferenceType(_tmpReferenceType);
                    String _tmpTargetId = _stmt.isNull(_columnIndexOfTargetId) ? null : _stmt.getText(_columnIndexOfTargetId);
                    _item_1.setTargetId(_tmpTargetId);
                    String _tmpTargetType = _stmt.isNull(_columnIndexOfTargetType) ? null : _stmt.getText(_columnIndexOfTargetType);
                    _item_1.setTargetType(_tmpTargetType);
                    String _tmpPostId = _stmt.isNull(_columnIndexOfPostId) ? null : _stmt.getText(_columnIndexOfPostId);
                    _item_1.setPostId(_tmpPostId);
                    String _tmpChannelId = _stmt.isNull(_columnIndexOfChannelId) ? null : _stmt.getText(_columnIndexOfChannelId);
                    _item_1.setChannelId(_tmpChannelId);
                    Integer _tmp_6 = _stmt.isNull(_columnIndexOfChannelEnabled) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfChannelEnabled));
                    Boolean _tmpChannelEnabled = _tmp_6 == null ? null : Boolean.valueOf(_tmp_6 != 0);
                    _item_1.setChannelEnabled(_tmpChannelEnabled);
                    Integer _tmp_7 = _stmt.isNull(_columnIndexOfIsBanned) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfIsBanned));
                    Boolean _tmpIsBanned = _tmp_7 == null ? null : Boolean.valueOf(_tmp_7 != 0);
                    _item_1.setBanned(_tmpIsBanned);
                    Integer _tmp_8 = _stmt.isNull(_columnIndexOfIsParent) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfIsParent));
                    Boolean _tmpIsParent = _tmp_8 == null ? null : Boolean.valueOf(_tmp_8 != 0);
                    _item_1.setParent(_tmpIsParent);
                    String _tmpParentStreamId = _stmt.isNull(_columnIndexOfParentStreamId) ? null : _stmt.getText(_columnIndexOfParentStreamId);
                    _item_1.setParentStreamId(_tmpParentStreamId);
                    String _tmp_9 = _stmt.isNull(_columnIndexOfChildStreamIds) ? null : _stmt.getText(_columnIndexOfChildStreamIds);
                    List<String> _tmpChildStreamIds = this.__stringListConverter.stringToStringList(_tmp_9);
                    _item_1.setChildStreamIds(_tmpChildStreamIds);
                    String _tmp_10 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_10);
                    _item_1.setCreatedAt(_tmpCreatedAt);
                    String _tmp_11 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_11);
                    _item_1.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_12 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_12);
                    _item_1.setExpiresAt(_tmpExpiresAt);
                    _result.add(_item_1);
                }
                ArrayList<EkoStreamEntity> arrayList = _result;
                return arrayList;
            }
        });
    }

    @Override
    public Flowable<EkoStreamEntity> getLatestStreamImpl(List<String> statuses, DateTime now) {
        StringBuilder _stringBuilder = new StringBuilder();
        _stringBuilder.append("SELECT * from stream where status in (");
        int _inputSize = statuses.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(") and stream.updatedAt > ");
        _stringBuilder.append("?");
        _stringBuilder.append(" and stream.isParent = 1 order by stream.updatedAt DESC limit 1");
        String _sql = _stringBuilder.toString();
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"stream"}, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare(_sql);){
                EkoStreamEntity _result;
                int _argIndex = 1;
                for (String _item : statuses) {
                    if (_item == null) {
                        _stmt.bindNull(_argIndex);
                    } else {
                        _stmt.bindText(_argIndex, _item);
                    }
                    ++_argIndex;
                }
                _argIndex = 1 + _inputSize;
                String _tmp = this.__dateTimeTypeConverter.dateTimeToString(now);
                if (_tmp == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, _tmp);
                }
                int _columnIndexOfStreamId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"streamId");
                int _columnIndexOfModerationId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"moderationId");
                int _columnIndexOfTitle = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"title");
                int _columnIndexOfDescription = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"description");
                int _columnIndexOfMetadata = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"metadata");
                int _columnIndexOfIsDeleted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isDeleted");
                int _columnIndexOfThumbnailFileId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"thumbnailFileId");
                int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userId");
                int _columnIndexOfWatcherData = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"watcherData");
                int _columnIndexOfBroadcasterData = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"broadcasterData");
                int _columnIndexOfRecordings = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"recordings");
                int _columnIndexOfStatus = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"status");
                int _columnIndexOfIsReconnecting = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isReconnecting");
                int _columnIndexOfResolution = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"resolution");
                int _columnIndexOfReferenceId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"referenceId");
                int _columnIndexOfReferenceType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"referenceType");
                int _columnIndexOfTargetId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetId");
                int _columnIndexOfTargetType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetType");
                int _columnIndexOfPostId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"postId");
                int _columnIndexOfChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelId");
                int _columnIndexOfChannelEnabled = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelEnabled");
                int _columnIndexOfIsBanned = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isBanned");
                int _columnIndexOfIsParent = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isParent");
                int _columnIndexOfParentStreamId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"parentStreamId");
                int _columnIndexOfChildStreamIds = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"childStreamIds");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    _result = new EkoStreamEntity();
                    String _tmpStreamId = _stmt.isNull(_columnIndexOfStreamId) ? null : _stmt.getText(_columnIndexOfStreamId);
                    _result.setStreamId(_tmpStreamId);
                    String _tmpModerationId = _stmt.isNull(_columnIndexOfModerationId) ? null : _stmt.getText(_columnIndexOfModerationId);
                    _result.setModerationId(_tmpModerationId);
                    String _tmpTitle = _stmt.isNull(_columnIndexOfTitle) ? null : _stmt.getText(_columnIndexOfTitle);
                    _result.setTitle(_tmpTitle);
                    String _tmpDescription = _stmt.isNull(_columnIndexOfDescription) ? null : _stmt.getText(_columnIndexOfDescription);
                    _result.setDescription(_tmpDescription);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfMetadata) ? null : _stmt.getText(_columnIndexOfMetadata);
                    JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_1);
                    _result.setMetadata(_tmpMetadata);
                    int _tmp_2 = (int)_stmt.getLong(_columnIndexOfIsDeleted);
                    boolean _tmpIsDeleted = _tmp_2 != 0;
                    _result.setDeleted(_tmpIsDeleted);
                    String _tmpThumbnailFileId = _stmt.isNull(_columnIndexOfThumbnailFileId) ? null : _stmt.getText(_columnIndexOfThumbnailFileId);
                    _result.setThumbnailFileId(_tmpThumbnailFileId);
                    String _tmpUserId = _stmt.isNull(_columnIndexOfUserId) ? null : _stmt.getText(_columnIndexOfUserId);
                    _result.setUserId(_tmpUserId);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfWatcherData) ? null : _stmt.getText(_columnIndexOfWatcherData);
                    JsonObject _tmpWatcherData = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_3);
                    _result.setWatcherData(_tmpWatcherData);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfBroadcasterData) ? null : _stmt.getText(_columnIndexOfBroadcasterData);
                    JsonObject _tmpBroadcasterData = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_4);
                    _result.setBroadcasterData(_tmpBroadcasterData);
                    String _tmp_5 = _stmt.isNull(_columnIndexOfRecordings) ? null : _stmt.getText(_columnIndexOfRecordings);
                    JsonArray _tmpRecordings = this.__jsonArrayTypeConverter.stringToJsonObject(_tmp_5);
                    _result.setRecordings(_tmpRecordings);
                    String _tmpStatus = _stmt.isNull(_columnIndexOfStatus) ? null : _stmt.getText(_columnIndexOfStatus);
                    _result.setStatus(_tmpStatus);
                    int _tmp_6 = (int)_stmt.getLong(_columnIndexOfIsReconnecting);
                    boolean _tmpIsReconnecting = _tmp_6 != 0;
                    _result.setReconnecting(_tmpIsReconnecting);
                    String _tmpResolution = _stmt.isNull(_columnIndexOfResolution) ? null : _stmt.getText(_columnIndexOfResolution);
                    _result.setResolution(_tmpResolution);
                    String _tmpReferenceId = _stmt.isNull(_columnIndexOfReferenceId) ? null : _stmt.getText(_columnIndexOfReferenceId);
                    _result.setReferenceId(_tmpReferenceId);
                    String _tmpReferenceType = _stmt.isNull(_columnIndexOfReferenceType) ? null : _stmt.getText(_columnIndexOfReferenceType);
                    _result.setReferenceType(_tmpReferenceType);
                    String _tmpTargetId = _stmt.isNull(_columnIndexOfTargetId) ? null : _stmt.getText(_columnIndexOfTargetId);
                    _result.setTargetId(_tmpTargetId);
                    String _tmpTargetType = _stmt.isNull(_columnIndexOfTargetType) ? null : _stmt.getText(_columnIndexOfTargetType);
                    _result.setTargetType(_tmpTargetType);
                    String _tmpPostId = _stmt.isNull(_columnIndexOfPostId) ? null : _stmt.getText(_columnIndexOfPostId);
                    _result.setPostId(_tmpPostId);
                    String _tmpChannelId = _stmt.isNull(_columnIndexOfChannelId) ? null : _stmt.getText(_columnIndexOfChannelId);
                    _result.setChannelId(_tmpChannelId);
                    Integer _tmp_7 = _stmt.isNull(_columnIndexOfChannelEnabled) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfChannelEnabled));
                    Boolean _tmpChannelEnabled = _tmp_7 == null ? null : Boolean.valueOf(_tmp_7 != 0);
                    _result.setChannelEnabled(_tmpChannelEnabled);
                    Integer _tmp_8 = _stmt.isNull(_columnIndexOfIsBanned) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfIsBanned));
                    Boolean _tmpIsBanned = _tmp_8 == null ? null : Boolean.valueOf(_tmp_8 != 0);
                    _result.setBanned(_tmpIsBanned);
                    Integer _tmp_9 = _stmt.isNull(_columnIndexOfIsParent) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfIsParent));
                    Boolean _tmpIsParent = _tmp_9 == null ? null : Boolean.valueOf(_tmp_9 != 0);
                    _result.setParent(_tmpIsParent);
                    String _tmpParentStreamId = _stmt.isNull(_columnIndexOfParentStreamId) ? null : _stmt.getText(_columnIndexOfParentStreamId);
                    _result.setParentStreamId(_tmpParentStreamId);
                    String _tmp_10 = _stmt.isNull(_columnIndexOfChildStreamIds) ? null : _stmt.getText(_columnIndexOfChildStreamIds);
                    List<String> _tmpChildStreamIds = this.__stringListConverter.stringToStringList(_tmp_10);
                    _result.setChildStreamIds(_tmpChildStreamIds);
                    String _tmp_11 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_11);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_12 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_12);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_13 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_13);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                EkoStreamEntity ekoStreamEntity = _result;
                return ekoStreamEntity;
            }
        });
    }

    @Override
    public void deleteAll() {
        String _sql = "DELETE from stream";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("DELETE from stream");){
                _stmt.step();
                Object var2_2 = null;
                return var2_2;
            }
        });
    }

    @Override
    public void softDeleteImpl() {
        String _sql = "UPDATE stream set isDeleted = 1 where isDeleted = 0";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("UPDATE stream set isDeleted = 1 where isDeleted = 0");){
                _stmt.step();
                Object var2_2 = null;
                return var2_2;
            }
        });
    }

    @Override
    public void updateStreamIsBannedImpl(String streamId, int isBanned) {
        String _sql = "UPDATE stream set isBanned = ? where streamId = ?";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("UPDATE stream set isBanned = ? where streamId = ?");){
                int _argIndex = 1;
                _stmt.bindLong(_argIndex, (long)isBanned);
                _argIndex = 2;
                if (streamId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, streamId);
                }
                _stmt.step();
                Object var5_5 = null;
                return var5_5;
            }
        });
    }

    @Override
    public void updateStreamImpl(String streamId) {
        String _sql = "UPDATE stream set streamId = ? where streamId = ?";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("UPDATE stream set streamId = ? where streamId = ?");){
                int _argIndex = 1;
                if (streamId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, streamId);
                }
                _argIndex = 2;
                if (streamId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, streamId);
                }
                _stmt.step();
                Object var4_4 = null;
                return var4_4;
            }
        });
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

