/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.chat.data.channel;

import androidx.paging.PagingSource;
import com.amity.socialcloud.sdk.chat.data.channel.ChannelHelper;
import com.amity.socialcloud.sdk.core.data.session.SessionLocalDataStore;
import com.amity.socialcloud.sdk.model.chat.channel.AmityChannel;
import com.amity.socialcloud.sdk.model.chat.channel.AmityChannelFilter;
import com.amity.socialcloud.sdk.model.core.tag.AmityTags;
import com.ekoapp.ekosdk.EkoChannelWithMembershipAndExtra;
import com.ekoapp.ekosdk.internal.EkoChannelEntity;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.dao.EkoChannelDao;
import com.ekoapp.ekosdk.internal.keycreator.DynamicQueryStreamKeyCreator;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J\u0010\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010\r\u001a\u00020\u000bJ\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u000f2\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\n\u001a\u00020\u000bJ\u0012\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00070\u000fJ\u001e\u0010\u0013\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\u0018\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001aJG\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\b0\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#2\b\u0010%\u001a\u0004\u0018\u00010\u001a\u00a2\u0006\u0002\u0010&J \u0010'\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u000f2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0007JQ\u0010)\u001a\b\u0012\u0004\u0012\u00020\b0\u000f2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#2\b\u0010%\u001a\u0004\u0018\u00010\u001a2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u0016\u00a2\u0006\u0002\u0010-J\u000e\u0010.\u001a\u00020\u001a2\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010/\u001a\u0002002\u0006\u0010\n\u001a\u00020\u000b2\u0006\u00101\u001a\u00020\u0016J\u0016\u00102\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u00103\u001a\u00020\u000bJ\u000e\u00104\u001a\u0002002\u0006\u0010\n\u001a\u00020\u000bJ\u0014\u00105\u001a\u0002002\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0007J\u000e\u00106\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b\u00a8\u00067"}, d2={"Lcom/amity/socialcloud/sdk/chat/data/channel/ChannelLocalDataStore;", "", "<init>", "()V", "saveChannels", "Lio/reactivex/rxjava3/core/Completable;", "channels", "", "Lcom/ekoapp/ekosdk/internal/EkoChannelEntity;", "getChannel", "channelId", "", "getChannelByInternalId", "internalChannelId", "observeChannel", "Lio/reactivex/rxjava3/core/Flowable;", "getMessagePreviewId", "getAllJoinedChannels", "Lcom/ekoapp/ekosdk/EkoChannelWithMembershipAndExtra;", "updateDefaultSubChannelMessageCount", "subChannelId", "segment", "", "updateLastActivity", "updateIsMuted", "isMuted", "", "getChannelPagingSource", "Landroidx/paging/PagingSource;", "types", "", "Lcom/amity/socialcloud/sdk/model/chat/channel/AmityChannel$Type;", "filter", "Lcom/amity/socialcloud/sdk/model/chat/channel/AmityChannelFilter;", "includingTags", "Lcom/amity/socialcloud/sdk/model/core/tag/AmityTags;", "excludingTags", "isDeleted", "(Ljava/util/Set;Lcom/amity/socialcloud/sdk/model/chat/channel/AmityChannelFilter;Lcom/amity/socialcloud/sdk/model/core/tag/AmityTags;Lcom/amity/socialcloud/sdk/model/core/tag/AmityTags;Ljava/lang/Boolean;)Landroidx/paging/PagingSource;", "getChannels", "channelIds", "getLatestChannel", "dynamicQueryStreamKeyCreator", "Lcom/ekoapp/ekosdk/internal/keycreator/DynamicQueryStreamKeyCreator;", "nonce", "(Ljava/util/Set;Lcom/amity/socialcloud/sdk/model/chat/channel/AmityChannelFilter;Lcom/amity/socialcloud/sdk/model/core/tag/AmityTags;Lcom/amity/socialcloud/sdk/model/core/tag/AmityTags;Ljava/lang/Boolean;Lcom/ekoapp/ekosdk/internal/keycreator/DynamicQueryStreamKeyCreator;I)Lio/reactivex/rxjava3/core/Flowable;", "hasInLocal", "updateMarkerHash", "", "hash", "updateMessagePreview", "messagePreviewId", "notifyChanges", "notifyChannelsChanges", "hardDelete", "amity-sdk_release"})
@SourceDebugExtension(value={"SMAP\nChannelLocalDataStore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChannelLocalDataStore.kt\ncom/amity/socialcloud/sdk/chat/data/channel/ChannelLocalDataStore\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,151:1\n37#2:152\n36#2,3:153\n37#2:156\n36#2,3:157\n37#2:160\n36#2,3:161\n37#2:164\n36#2,3:165\n*S KotlinDebug\n*F\n+ 1 ChannelLocalDataStore.kt\ncom/amity/socialcloud/sdk/chat/data/channel/ChannelLocalDataStore\n*L\n103#1:152\n103#1:153,3\n105#1:156\n105#1:157,3\n106#1:160\n106#1:161,3\n107#1:164\n107#1:165,3\n*E\n"})
public final class ChannelLocalDataStore {
    @NotNull
    public final Completable saveChannels(@NotNull List<? extends EkoChannelEntity> channels) {
        Intrinsics.checkNotNullParameter(channels, (String)"channels");
        Completable completable = Completable.fromAction(() -> ChannelLocalDataStore.saveChannels$lambda$0(channels));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"fromAction(...)");
        return completable;
    }

    @Nullable
    public final EkoChannelEntity getChannel(@NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        return UserDatabase.get().channelDao().getByIdNow(channelId);
    }

    @Nullable
    public final EkoChannelEntity getChannelByInternalId(@NotNull String internalChannelId) {
        Intrinsics.checkNotNullParameter((Object)internalChannelId, (String)"internalChannelId");
        return UserDatabase.get().channelDao().getByInternalIdNow(internalChannelId);
    }

    @NotNull
    public final Flowable<EkoChannelEntity> observeChannel(@NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        return UserDatabase.get().channelDao().getChannel(channelId);
    }

    @Nullable
    public final String getMessagePreviewId(@NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        return UserDatabase.get().channelDao().getMessagePreviewId(channelId);
    }

    @NotNull
    public final Flowable<List<EkoChannelWithMembershipAndExtra>> getAllJoinedChannels() {
        return UserDatabase.get().channelDao().getAllJoinedChannels(new SessionLocalDataStore().getActiveUserId());
    }

    @NotNull
    public final Completable updateDefaultSubChannelMessageCount(@NotNull String channelId, @NotNull String subChannelId, int segment) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)subChannelId, (String)"subChannelId");
        Completable completable = Completable.fromAction(() -> ChannelLocalDataStore.updateDefaultSubChannelMessageCount$lambda$1(this, subChannelId, channelId, segment)).subscribeOn(Schedulers.io());
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"subscribeOn(...)");
        return completable;
    }

    @NotNull
    public final Completable updateLastActivity(@NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Completable completable = Completable.fromAction(() -> ChannelLocalDataStore.updateLastActivity$lambda$2(channelId)).subscribeOn(Schedulers.io());
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"subscribeOn(...)");
        return completable;
    }

    @NotNull
    public final Completable updateIsMuted(@NotNull String channelId, boolean isMuted) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Completable completable = Completable.fromAction(() -> ChannelLocalDataStore.updateIsMuted$lambda$3(channelId, isMuted)).subscribeOn(Schedulers.io());
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"subscribeOn(...)");
        return completable;
    }

    @NotNull
    public final PagingSource<Integer, EkoChannelEntity> getChannelPagingSource(@NotNull Set<? extends AmityChannel.Type> types, @NotNull AmityChannelFilter filter, @NotNull AmityTags includingTags, @NotNull AmityTags excludingTags, @Nullable Boolean isDeleted) {
        Intrinsics.checkNotNullParameter(types, (String)"types");
        Intrinsics.checkNotNullParameter((Object)((Object)filter), (String)"filter");
        Intrinsics.checkNotNullParameter((Object)includingTags, (String)"includingTags");
        Intrinsics.checkNotNullParameter((Object)excludingTags, (String)"excludingTags");
        return UserDatabase.get().channelPagingDao().getChannelPagingSource(types, filter, includingTags, excludingTags, isDeleted);
    }

    @NotNull
    public final Flowable<List<EkoChannelEntity>> getChannels(@NotNull List<String> channelIds) {
        Intrinsics.checkNotNullParameter(channelIds, (String)"channelIds");
        return UserDatabase.get().channelListPagingDao().getChannels(channelIds);
    }

    @NotNull
    public final Flowable<EkoChannelEntity> getLatestChannel(@NotNull Set<? extends AmityChannel.Type> types, @NotNull AmityChannelFilter filter, @NotNull AmityTags includingTags, @NotNull AmityTags excludingTags, @Nullable Boolean isDeleted, @NotNull DynamicQueryStreamKeyCreator dynamicQueryStreamKeyCreator, int nonce) {
        Intrinsics.checkNotNullParameter(types, (String)"types");
        Intrinsics.checkNotNullParameter((Object)((Object)filter), (String)"filter");
        Intrinsics.checkNotNullParameter((Object)includingTags, (String)"includingTags");
        Intrinsics.checkNotNullParameter((Object)excludingTags, (String)"excludingTags");
        Intrinsics.checkNotNullParameter((Object)dynamicQueryStreamKeyCreator, (String)"dynamicQueryStreamKeyCreator");
        EkoChannelDao ekoChannelDao = UserDatabase.get().channelDao();
        Collection $this$toTypedArray$iv = ChannelHelper.INSTANCE.getChannelTypes(types);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String string = new SessionLocalDataStore().getActiveUserId();
        $this$toTypedArray$iv = filter.getMemberships();
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        $this$toTypedArray$iv = includingTags;
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        $this$toTypedArray$iv = excludingTags;
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        int n = ((Object)dynamicQueryStreamKeyCreator.toMap()).hashCode();
        DateTime dateTime = DateTime.now();
        Intrinsics.checkNotNullExpressionValue((Object)dateTime, (String)"now(...)");
        return ekoChannelDao.getLatestChannel(thisCollection$iv.toArray(new String[0]), string, thisCollection$iv.toArray(new String[0]), thisCollection$iv.toArray(new String[0]), thisCollection$iv.toArray(new String[0]), isDeleted, n, nonce, dateTime);
    }

    public final boolean hasInLocal(@NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Ref.BooleanRef hasInLocal = new Ref.BooleanRef();
        Completable.fromCallable(() -> ChannelLocalDataStore.hasInLocal$lambda$4(channelId, hasInLocal)).subscribeOn(Schedulers.io()).blockingAwait();
        return hasInLocal.element;
    }

    public final void updateMarkerHash(@NotNull String channelId, int hash) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        UserDatabase.get().channelDao().updateMarkerHash(channelId, hash);
    }

    @NotNull
    public final Completable updateMessagePreview(@NotNull String channelId, @NotNull String messagePreviewId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)messagePreviewId, (String)"messagePreviewId");
        Completable completable = Completable.fromAction(() -> ChannelLocalDataStore.updateMessagePreview$lambda$5(channelId, messagePreviewId)).subscribeOn(Schedulers.io());
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"subscribeOn(...)");
        return completable;
    }

    public final void notifyChanges(@NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        UserDatabase.get().channelDao().notifyChanges(channelId);
    }

    public final void notifyChannelsChanges(@NotNull List<String> channelIds) {
        Intrinsics.checkNotNullParameter(channelIds, (String)"channelIds");
        UserDatabase.get().channelDao().notifyChannelsChanges(channelIds, ((Object)channelIds).hashCode());
    }

    @NotNull
    public final Completable hardDelete(@NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Completable completable = Completable.fromAction(() -> ChannelLocalDataStore.hardDelete$lambda$6(channelId)).subscribeOn(Schedulers.io());
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"subscribeOn(...)");
        return completable;
    }

    private static final void saveChannels$lambda$0(List $channels) {
        UserDatabase.get().channelDao().save($channels);
    }

    private static final void updateDefaultSubChannelMessageCount$lambda$1(ChannelLocalDataStore this$0, String $subChannelId, String $channelId, int $segment) {
        EkoChannelEntity cachedChannel = this$0.getChannelByInternalId($subChannelId);
        if (cachedChannel != null) {
            UserDatabase.get().channelDao().updateMessageCount($channelId, $segment);
        }
    }

    private static final void updateLastActivity$lambda$2(String $channelId) {
        EkoChannelDao ekoChannelDao = UserDatabase.get().channelDao();
        DateTime dateTime = DateTime.now();
        Intrinsics.checkNotNullExpressionValue((Object)dateTime, (String)"now(...)");
        ekoChannelDao.updateLastActivity($channelId, dateTime);
    }

    private static final void updateIsMuted$lambda$3(String $channelId, boolean $isMuted) {
        UserDatabase.get().channelDao().updateIsMuted($channelId, $isMuted);
    }

    private static final Unit hasInLocal$lambda$4(String $channelId, Ref.BooleanRef $hasInLocal) {
        EkoChannelDao channelDao = UserDatabase.get().channelDao();
        EkoChannelEntity entity = channelDao.getByIdNow($channelId);
        if (entity != null) {
            $hasInLocal.element = true;
        }
        return Unit.INSTANCE;
    }

    private static final void updateMessagePreview$lambda$5(String $channelId, String $messagePreviewId) {
        UserDatabase.get().channelDao().updateMessagePreview($channelId, $messagePreviewId);
    }

    private static final void hardDelete$lambda$6(String $channelId) {
        UserDatabase.get().channelDao().deleteById($channelId);
    }
}

