package com.amity.socialcloud.sdk.social.domain.post.create

import com.amity.socialcloud.sdk.model.core.error.AmityError
import com.amity.socialcloud.sdk.model.core.error.AmityException
import com.amity.socialcloud.sdk.model.social.post.AmityPost
import com.amity.socialcloud.sdk.social.data.post.PostRepository
import com.amity.socialcloud.sdk.social.domain.post.PostGetUseCase
import com.ekoapp.ekosdk.internal.usecase.post.PostCreateUseCase
import com.google.gson.JsonObject
import io.reactivex.rxjava3.core.Single


internal class CustomPostCreateUseCase : PostCreateUseCase {

    fun execute(
        targetType: String,
        targetId: String,
        dataType: AmityPost.DataType.CUSTOM,
        data: JsonObject,
        metadata: JsonObject?,
        mentionUserIds: List<String>?,
        hashtags: List<String>?,
    ): Single<AmityPost> {
        return PostRepository().createPostV4(
            targetType = targetType,
            targetId = targetId,
            data = data,
            dataType = dataType,
            attachments = null,
            metadata = metadata,
            mentionees = mapMentionees(mentionUserIds),
            hashtags = hashtags,
        ).flatMap {
            val post = PostGetUseCase().execute(it)
            if (post != null) {
                Single.just(post)
            } else {
                Single.error(
                    AmityException.create(
                        "Post not found",
                        null,
                        AmityError.ITEM_NOT_FOUND
                    )
                )
            }
        }
    }

}