package com.ekoapp.ekosdk.internal.usecase.user

import androidx.paging.PagingData
import androidx.paging.map
import com.amity.socialcloud.sdk.core.data.follow.FollowRepository
import com.amity.socialcloud.sdk.core.domain.user.UserGetUseCase
import com.amity.socialcloud.sdk.model.core.user.AmityUser
import io.reactivex.rxjava3.core.Flowable
import java.util.concurrent.Executors

internal class GetBlockedUsersPagingDataUseCase {

    fun execute(): Flowable<PagingData<AmityUser>> {
        return FollowRepository().getBlockedUsersPagingData()
            .map { pagingData ->
                pagingData.map(Executors.newSingleThreadExecutor()) {
                    UserGetUseCase().execute(it.getTargetUser()?.getUserId()!!)!!
                }
            }
    }
}