package com.ekoapp.ekosdk.internal.usecase.post

import com.amity.socialcloud.sdk.api.social.post.review.AmityReviewStatus
import com.amity.socialcloud.sdk.core.data.pin.PinRepository
import com.amity.socialcloud.sdk.model.core.pin.AmityPinnedPost
import com.amity.socialcloud.sdk.model.social.post.AmityPost
import com.amity.socialcloud.sdk.social.domain.post.PinnedPostComposerUseCase
import io.reactivex.rxjava3.core.Flowable


internal class GlobalPinnedPostQueryUseCase {

    fun execute(includeMixedStructure: Boolean): Flowable<List<AmityPinnedPost>> {
        return PinRepository().getGlobalPinnedPostPagingData(includeMixedStructure = includeMixedStructure)
            .map { list ->
                val attachLinkedObjects = list.map { pin ->
                    PinnedPostComposerUseCase().execute(pin)
                }
                attachLinkedObjects.filter {
                    it.post?.isDeleted() == false
                            && it.post?.getReviewStatus() == AmityReviewStatus.PUBLISHED
                            && (includeMixedStructure || it.post?.getStructureType() != AmityPost.StructureType.MIXED)
                }
            }
    }

}