package com.amity.socialcloud.sdk.core.data.pin

import androidx.paging.ExperimentalPagingApi
import androidx.paging.PagingConfig
import androidx.paging.PagingData
import co.amity.rxbridge.toRx3
import com.amity.socialcloud.sdk.core.data.pin.paging.GlobalPinnedPostMediator
import com.amity.socialcloud.sdk.core.data.pin.paging.PinnedPostMediator
import com.amity.socialcloud.sdk.model.core.pin.AmityPinSortByOptions
import com.amity.socialcloud.sdk.model.core.pin.AmityPinnedPost
import com.amity.socialcloud.sdk.social.data.story.StoryLocalDataStore
import com.amity.socialcloud.sdk.social.data.story.StoryModelMapper
import com.amity.socialcloud.sdk.social.data.story.StorySinglePageMediator
import com.ekoapp.ekosdk.EkoObjectRepository
import com.ekoapp.ekosdk.internal.paging.DynamicQueryStreamPagerCreator
import com.ekoapp.ekosdk.internal.paging.SinglePagePagerCreator
import io.reactivex.rxjava3.core.Flowable

@OptIn(ExperimentalPagingApi::class)
internal class PinRepository() : EkoObjectRepository() {
	
	private fun getDefaultPageSize(): Int {
		return DEFAULT_PAGE_SIZE
	}

	fun getPinnedPostPagingData(
		targetId: String,
		targetType: String,
		placement: String? = null,
		includeMixedStructure: Boolean,
		sortByOptions: AmityPinSortByOptions,
	): Flowable<PagingData<AmityPinnedPost>> {
		val pagerCreator = DynamicQueryStreamPagerCreator(
			pagingConfig = PagingConfig(
				pageSize = getDefaultPageSize(),
				enablePlaceholders = false
			),
			dynamicQueryStreamMediator = PinnedPostMediator(
				targetId = targetId,
				targetType = targetType,
				placement = placement,
				includeMixedStructure = includeMixedStructure,
			),
			pagingSourceFactory = {
				PinLocalDataStore().getPinnedPostPagingSource(
					targetId = targetId,
					targetType = targetType,
					placement = placement,
					includeMixedStructure = includeMixedStructure,
				)
			},
			modelMapper = PinnedPostModelMapper()
		)
		return pagerCreator.create().toRx3()
	}

	fun getGlobalPinnedPostPagingData(includeMixedStructure: Boolean): Flowable<List<AmityPinnedPost>> {

		val pagerCreator = SinglePagePagerCreator(
			mediator = GlobalPinnedPostMediator(
				includeMixedStructure = includeMixedStructure
			),
			domainDatasource = PinLocalDataStore().getGlobalPinnedPostPagingSource(
				includeMixedStructure = includeMixedStructure
			),
			modelMapper = PinnedPostModelMapper()
		)

		return pagerCreator.create()
	}
}

