package com.amity.socialcloud.sdk.core.domain.notificationtray.get

import androidx.paging.PagingData
import androidx.paging.map
import com.amity.socialcloud.sdk.core.data.notificationtray.NotificationTrayItemRepository
import com.amity.socialcloud.sdk.core.domain.notificationtray.composer.NotificationTrayComposerUseCase
import com.amity.socialcloud.sdk.model.core.notificationtray.AmityNotificationTrayItem
import io.reactivex.rxjava3.core.Flowable
import java.util.concurrent.Executors

class GetNotificationTrayItemUseCase {
    fun execute(): Flowable<PagingData<AmityNotificationTrayItem>> {
        return NotificationTrayItemRepository().getNotificationTrayItemPagingData()
            .map { pagingData ->
                pagingData.map(Executors.newSingleThreadExecutor()) { notiTrayItem ->
                    NotificationTrayComposerUseCase().execute(notiTrayItem)
                }
            }
    }
}