package com.amity.socialcloud.sdk.chat.domain.message.preview

import com.amity.socialcloud.sdk.chat.data.message.preview.MessagePreviewRepository
import com.amity.socialcloud.sdk.model.chat.message.AmityMessagePreview
import io.reactivex.rxjava3.core.Completable
import io.reactivex.rxjava3.schedulers.Schedulers

internal class MessagePreviewGetUseCase {

    fun execute(messagePreviewId: String) : AmityMessagePreview? {
        val messagePreview = MessagePreviewRepository().getMessagePreview(messagePreviewId)
        Completable.fromCallable {
            messagePreview?.let(MessagePreviewComposerUseCase()::execute)
        }.subscribeOn(Schedulers.io())
            .blockingAwait()
        return  messagePreview
    }

}