/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import androidx.annotation.NonNull;
import androidx.room.EntityDeleteOrUpdateAdapter;
import androidx.room.EntityInsertAdapter;
import androidx.room.RoomDatabase;
import androidx.room.rxjava3.RxRoom;
import androidx.room.util.DBUtil;
import androidx.room.util.SQLiteStatementUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.SQLiteStatement;
import com.ekoapp.ekosdk.internal.data.converter.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.data.dao.EkoFollowDao;
import com.ekoapp.ekosdk.internal.data.model.EkoUserFollowStatusEntity;
import io.reactivex.rxjava3.core.Flowable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kotlin.Unit;
import org.joda.time.DateTime;

public final class EkoFollowDao_Impl
extends EkoFollowDao {
    private final RoomDatabase __db;
    private final EntityInsertAdapter<EkoUserFollowStatusEntity> __insertAdapterOfEkoUserFollowStatusEntity;
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EntityDeleteOrUpdateAdapter<EkoUserFollowStatusEntity> __deleteAdapterOfEkoUserFollowStatusEntity;
    private final EntityDeleteOrUpdateAdapter<EkoUserFollowStatusEntity> __updateAdapterOfEkoUserFollowStatusEntity;

    public EkoFollowDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertAdapterOfEkoUserFollowStatusEntity = new EntityInsertAdapter<EkoUserFollowStatusEntity>(){

            @NonNull
            protected String createQuery() {
                return "INSERT OR REPLACE INTO `user_follow` (`id`,`sourceUserId`,`targetUserId`,`status`,`createdAt`,`updatedAt`,`expiresAt`) VALUES (?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull EkoUserFollowStatusEntity entity) {
                if (entity.getId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getId());
                }
                if (entity.getSourceUserId() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindText(2, entity.getSourceUserId());
                }
                if (entity.getTargetUserId() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindText(3, entity.getTargetUserId());
                }
                if (entity.getStatus() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindText(4, entity.getStatus());
                }
                String _tmp = EkoFollowDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, _tmp);
                }
                String _tmp_1 = EkoFollowDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_1 == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindText(6, _tmp_1);
                }
                String _tmp_2 = EkoFollowDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_2 == null) {
                    statement.bindNull(7);
                } else {
                    statement.bindText(7, _tmp_2);
                }
            }
        };
        this.__deleteAdapterOfEkoUserFollowStatusEntity = new EntityDeleteOrUpdateAdapter<EkoUserFollowStatusEntity>(){

            @NonNull
            protected String createQuery() {
                return "DELETE FROM `user_follow` WHERE `sourceUserId` = ? AND `targetUserId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull EkoUserFollowStatusEntity entity) {
                if (entity.getSourceUserId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getSourceUserId());
                }
                if (entity.getTargetUserId() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindText(2, entity.getTargetUserId());
                }
            }
        };
        this.__updateAdapterOfEkoUserFollowStatusEntity = new EntityDeleteOrUpdateAdapter<EkoUserFollowStatusEntity>(){

            @NonNull
            protected String createQuery() {
                return "UPDATE OR ABORT `user_follow` SET `id` = ?,`sourceUserId` = ?,`targetUserId` = ?,`status` = ?,`createdAt` = ?,`updatedAt` = ?,`expiresAt` = ? WHERE `sourceUserId` = ? AND `targetUserId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull EkoUserFollowStatusEntity entity) {
                if (entity.getId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getId());
                }
                if (entity.getSourceUserId() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindText(2, entity.getSourceUserId());
                }
                if (entity.getTargetUserId() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindText(3, entity.getTargetUserId());
                }
                if (entity.getStatus() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindText(4, entity.getStatus());
                }
                String _tmp = EkoFollowDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, _tmp);
                }
                String _tmp_1 = EkoFollowDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_1 == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindText(6, _tmp_1);
                }
                String _tmp_2 = EkoFollowDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_2 == null) {
                    statement.bindNull(7);
                } else {
                    statement.bindText(7, _tmp_2);
                }
                if (entity.getSourceUserId() == null) {
                    statement.bindNull(8);
                } else {
                    statement.bindText(8, entity.getSourceUserId());
                }
                if (entity.getTargetUserId() == null) {
                    statement.bindNull(9);
                } else {
                    statement.bindText(9, entity.getTargetUserId());
                }
            }
        };
    }

    @Override
    public void insertImpl(EkoUserFollowStatusEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfEkoUserFollowStatusEntity.insert(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insertImpl(List<? extends EkoUserFollowStatusEntity> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfEkoUserFollowStatusEntity.insert(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void delete(EkoUserFollowStatusEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfEkoUserFollowStatusEntity.handle(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void delete(List<? extends EkoUserFollowStatusEntity> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfEkoUserFollowStatusEntity.handleMultiple(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void updateImpl(EkoUserFollowStatusEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__updateAdapterOfEkoUserFollowStatusEntity.handle(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insert(EkoUserFollowStatusEntity object) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            EkoFollowDao_Impl.super.insert(object);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void insert(List<? extends EkoUserFollowStatusEntity> objects) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            EkoFollowDao_Impl.super.insert(objects);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void update(EkoUserFollowStatusEntity object) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            EkoFollowDao_Impl.super.update(object);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void updateUser(String userId) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            EkoFollowDao_Impl.super.updateUser(userId);
            return Unit.INSTANCE;
        });
    }

    @Override
    EkoUserFollowStatusEntity getByIdNowImpl(String id) {
        String _sql = "SELECT * from user_follow where id = ? LIMIT 1";
        return (EkoUserFollowStatusEntity)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from user_follow where id = ? LIMIT 1");){
                EkoUserFollowStatusEntity _result;
                int _argIndex = 1;
                if (id == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, id);
                }
                int _columnIndexOfId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"id");
                int _columnIndexOfSourceUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"sourceUserId");
                int _columnIndexOfTargetUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetUserId");
                int _columnIndexOfStatus = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"status");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    String _tmpId = _stmt.isNull(_columnIndexOfId) ? null : _stmt.getText(_columnIndexOfId);
                    String _tmpSourceUserId = _stmt.isNull(_columnIndexOfSourceUserId) ? null : _stmt.getText(_columnIndexOfSourceUserId);
                    String _tmpTargetUserId = _stmt.isNull(_columnIndexOfTargetUserId) ? null : _stmt.getText(_columnIndexOfTargetUserId);
                    String _tmpStatus = _stmt.isNull(_columnIndexOfStatus) ? null : _stmt.getText(_columnIndexOfStatus);
                    _result = new EkoUserFollowStatusEntity(_tmpId, _tmpSourceUserId, _tmpTargetUserId, _tmpStatus);
                    String _tmp = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                EkoUserFollowStatusEntity ekoUserFollowStatusEntity = _result;
                return ekoUserFollowStatusEntity;
            }
        });
    }

    @Override
    List<EkoUserFollowStatusEntity> getByIdsNowImpl(List<String> ids) {
        StringBuilder _stringBuilder = new StringBuilder();
        _stringBuilder.append("SELECT * from user_follow where id IN (");
        int _inputSize = ids == null ? 1 : ids.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        return (List)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare(_sql);){
                int _argIndex = 1;
                if (ids == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    for (String _item : ids) {
                        if (_item == null) {
                            _stmt.bindNull(_argIndex);
                        } else {
                            _stmt.bindText(_argIndex, _item);
                        }
                        ++_argIndex;
                    }
                }
                int _columnIndexOfId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"id");
                int _columnIndexOfSourceUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"sourceUserId");
                int _columnIndexOfTargetUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetUserId");
                int _columnIndexOfStatus = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"status");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                ArrayList<EkoUserFollowStatusEntity> _result = new ArrayList<EkoUserFollowStatusEntity>();
                while (_stmt.step()) {
                    String _tmpId = _stmt.isNull(_columnIndexOfId) ? null : _stmt.getText(_columnIndexOfId);
                    String _tmpSourceUserId = _stmt.isNull(_columnIndexOfSourceUserId) ? null : _stmt.getText(_columnIndexOfSourceUserId);
                    String _tmpTargetUserId = _stmt.isNull(_columnIndexOfTargetUserId) ? null : _stmt.getText(_columnIndexOfTargetUserId);
                    String _tmpStatus = _stmt.isNull(_columnIndexOfStatus) ? null : _stmt.getText(_columnIndexOfStatus);
                    EkoUserFollowStatusEntity _item_1 = new EkoUserFollowStatusEntity(_tmpId, _tmpSourceUserId, _tmpTargetUserId, _tmpStatus);
                    String _tmp = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                    _item_1.setCreatedAt(_tmpCreatedAt);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                    _item_1.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _item_1.setExpiresAt(_tmpExpiresAt);
                    _result.add(_item_1);
                }
                ArrayList<EkoUserFollowStatusEntity> arrayList = _result;
                return arrayList;
            }
        });
    }

    @Override
    Flowable<EkoUserFollowStatusEntity> getAllByIdImpl(String sourceUserId, String targetUserId) {
        String _sql = "SELECT * from user_follow where sourceUserId = ? and targetUserId = ? LIMIT 1";
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"user_follow"}, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from user_follow where sourceUserId = ? and targetUserId = ? LIMIT 1");){
                EkoUserFollowStatusEntity _result;
                int _argIndex = 1;
                if (sourceUserId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, sourceUserId);
                }
                _argIndex = 2;
                if (targetUserId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, targetUserId);
                }
                int _columnIndexOfId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"id");
                int _columnIndexOfSourceUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"sourceUserId");
                int _columnIndexOfTargetUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetUserId");
                int _columnIndexOfStatus = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"status");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    String _tmpId = _stmt.isNull(_columnIndexOfId) ? null : _stmt.getText(_columnIndexOfId);
                    String _tmpSourceUserId = _stmt.isNull(_columnIndexOfSourceUserId) ? null : _stmt.getText(_columnIndexOfSourceUserId);
                    String _tmpTargetUserId = _stmt.isNull(_columnIndexOfTargetUserId) ? null : _stmt.getText(_columnIndexOfTargetUserId);
                    String _tmpStatus = _stmt.isNull(_columnIndexOfStatus) ? null : _stmt.getText(_columnIndexOfStatus);
                    _result = new EkoUserFollowStatusEntity(_tmpId, _tmpSourceUserId, _tmpTargetUserId, _tmpStatus);
                    String _tmp = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                EkoUserFollowStatusEntity ekoUserFollowStatusEntity = _result;
                return ekoUserFollowStatusEntity;
            }
        });
    }

    @Override
    Flowable<EkoUserFollowStatusEntity> getLatestFollowingImpl(String userId, List<String> statuses, DateTime now) {
        StringBuilder _stringBuilder = new StringBuilder();
        _stringBuilder.append("SELECT * from user_follow where user_follow.sourceUserId = ");
        _stringBuilder.append("?");
        _stringBuilder.append(" and user_follow.status in (");
        int _inputSize = statuses == null ? 1 : statuses.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(") and user_follow.updatedAt > ");
        _stringBuilder.append("?");
        _stringBuilder.append(" order by user_follow.updatedAt  desc limit 1");
        String _sql = _stringBuilder.toString();
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"user_follow"}, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare(_sql);){
                EkoUserFollowStatusEntity _result;
                int _argIndex = 1;
                if (userId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, userId);
                }
                _argIndex = 2;
                if (statuses == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    for (String _item : statuses) {
                        if (_item == null) {
                            _stmt.bindNull(_argIndex);
                        } else {
                            _stmt.bindText(_argIndex, _item);
                        }
                        ++_argIndex;
                    }
                }
                _argIndex = 2 + _inputSize;
                String _tmp = this.__dateTimeTypeConverter.dateTimeToString(now);
                if (_tmp == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, _tmp);
                }
                int _columnIndexOfId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"id");
                int _columnIndexOfSourceUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"sourceUserId");
                int _columnIndexOfTargetUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetUserId");
                int _columnIndexOfStatus = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"status");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    String _tmpId = _stmt.isNull(_columnIndexOfId) ? null : _stmt.getText(_columnIndexOfId);
                    String _tmpSourceUserId = _stmt.isNull(_columnIndexOfSourceUserId) ? null : _stmt.getText(_columnIndexOfSourceUserId);
                    String _tmpTargetUserId = _stmt.isNull(_columnIndexOfTargetUserId) ? null : _stmt.getText(_columnIndexOfTargetUserId);
                    String _tmpStatus = _stmt.isNull(_columnIndexOfStatus) ? null : _stmt.getText(_columnIndexOfStatus);
                    _result = new EkoUserFollowStatusEntity(_tmpId, _tmpSourceUserId, _tmpTargetUserId, _tmpStatus);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                EkoUserFollowStatusEntity ekoUserFollowStatusEntity = _result;
                return ekoUserFollowStatusEntity;
            }
        });
    }

    @Override
    Flowable<EkoUserFollowStatusEntity> getLatestFollowerImpl(String userId, List<String> statuses, DateTime now) {
        StringBuilder _stringBuilder = new StringBuilder();
        _stringBuilder.append("SELECT * from user_follow where user_follow.targetUserId = ");
        _stringBuilder.append("?");
        _stringBuilder.append(" and user_follow.status in (");
        int _inputSize = statuses == null ? 1 : statuses.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(") and user_follow.updatedAt > ");
        _stringBuilder.append("?");
        _stringBuilder.append(" order by user_follow.updatedAt  desc limit 1");
        String _sql = _stringBuilder.toString();
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"user_follow"}, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare(_sql);){
                EkoUserFollowStatusEntity _result;
                int _argIndex = 1;
                if (userId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, userId);
                }
                _argIndex = 2;
                if (statuses == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    for (String _item : statuses) {
                        if (_item == null) {
                            _stmt.bindNull(_argIndex);
                        } else {
                            _stmt.bindText(_argIndex, _item);
                        }
                        ++_argIndex;
                    }
                }
                _argIndex = 2 + _inputSize;
                String _tmp = this.__dateTimeTypeConverter.dateTimeToString(now);
                if (_tmp == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, _tmp);
                }
                int _columnIndexOfId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"id");
                int _columnIndexOfSourceUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"sourceUserId");
                int _columnIndexOfTargetUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetUserId");
                int _columnIndexOfStatus = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"status");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    String _tmpId = _stmt.isNull(_columnIndexOfId) ? null : _stmt.getText(_columnIndexOfId);
                    String _tmpSourceUserId = _stmt.isNull(_columnIndexOfSourceUserId) ? null : _stmt.getText(_columnIndexOfSourceUserId);
                    String _tmpTargetUserId = _stmt.isNull(_columnIndexOfTargetUserId) ? null : _stmt.getText(_columnIndexOfTargetUserId);
                    String _tmpStatus = _stmt.isNull(_columnIndexOfStatus) ? null : _stmt.getText(_columnIndexOfStatus);
                    _result = new EkoUserFollowStatusEntity(_tmpId, _tmpSourceUserId, _tmpTargetUserId, _tmpStatus);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                EkoUserFollowStatusEntity ekoUserFollowStatusEntity = _result;
                return ekoUserFollowStatusEntity;
            }
        });
    }

    @Override
    public void deleteAll() {
        String _sql = "DELETE from user_follow";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("DELETE from user_follow");){
                _stmt.step();
                Object var2_2 = null;
                return var2_2;
            }
        });
    }

    @Override
    public void updateFollowing(String userId, String status) {
        String _sql = "UPDATE user_follow set status = ? where targetUserId = ?";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("UPDATE user_follow set status = ? where targetUserId = ?");){
                int _argIndex = 1;
                if (status == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, status);
                }
                _argIndex = 2;
                if (userId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, userId);
                }
                _stmt.step();
                Object var5_5 = null;
                return var5_5;
            }
        });
    }

    @Override
    public void updateFollower(String userId, String status) {
        String _sql = "UPDATE user_follow set status = ? where sourceUserId = ?";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("UPDATE user_follow set status = ? where sourceUserId = ?");){
                int _argIndex = 1;
                if (status == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, status);
                }
                _argIndex = 2;
                if (userId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, userId);
                }
                _stmt.step();
                Object var5_5 = null;
                return var5_5;
            }
        });
    }

    @Override
    public void deleteBySourceAndTarget(String sourceUserId, String targetUserId) {
        String _sql = "DELETE from user_follow where sourceUserId = ? and targetUserId = ?";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("DELETE from user_follow where sourceUserId = ? and targetUserId = ?");){
                int _argIndex = 1;
                if (sourceUserId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, sourceUserId);
                }
                _argIndex = 2;
                if (targetUserId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, targetUserId);
                }
                _stmt.step();
                Object var5_5 = null;
                return var5_5;
            }
        });
    }

    @Override
    void updateSourceUserImpl(String userId) {
        String _sql = "UPDATE user_follow set sourceUserId = ? where sourceUserId = ?";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("UPDATE user_follow set sourceUserId = ? where sourceUserId = ?");){
                int _argIndex = 1;
                if (userId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, userId);
                }
                _argIndex = 2;
                if (userId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, userId);
                }
                _stmt.step();
                Object var4_4 = null;
                return var4_4;
            }
        });
    }

    @Override
    void updateTargetUserImpl(String userId) {
        String _sql = "UPDATE user_follow set targetUserId = ? where targetUserId = ?";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("UPDATE user_follow set targetUserId = ? where targetUserId = ?");){
                int _argIndex = 1;
                if (userId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, userId);
                }
                _argIndex = 2;
                if (userId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, userId);
                }
                _stmt.step();
                Object var4_4 = null;
                return var4_4;
            }
        });
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

