/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import androidx.annotation.NonNull;
import androidx.room.EntityDeleteOrUpdateAdapter;
import androidx.room.EntityInsertAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RxRoom;
import androidx.room.util.DBUtil;
import androidx.room.util.SQLiteStatementUtil;
import androidx.sqlite.SQLiteStatement;
import com.ekoapp.ekosdk.EkoFlag;
import com.ekoapp.ekosdk.internal.EkoLocalFlag;
import com.ekoapp.ekosdk.internal.data.converter.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.EkoFlagTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.EkoLocalFlagTypeConverter;
import com.ekoapp.ekosdk.internal.data.dao.EkoCommentFlagDao;
import com.ekoapp.ekosdk.internal.data.model.EkoCommentFlagEntity;
import io.reactivex.Flowable;
import java.util.Collections;
import java.util.List;
import kotlin.Unit;
import org.joda.time.DateTime;

public final class EkoCommentFlagDao_Impl
extends EkoCommentFlagDao {
    private final RoomDatabase __db;
    private final EntityInsertAdapter<EkoCommentFlagEntity> __insertAdapterOfEkoCommentFlagEntity;
    private final EkoFlagTypeConverter __ekoFlagTypeConverter = new EkoFlagTypeConverter();
    private final EkoLocalFlagTypeConverter __ekoLocalFlagTypeConverter = new EkoLocalFlagTypeConverter();
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EntityDeleteOrUpdateAdapter<EkoCommentFlagEntity> __deleteAdapterOfEkoCommentFlagEntity;
    private final EntityDeleteOrUpdateAdapter<EkoCommentFlagEntity> __updateAdapterOfEkoCommentFlagEntity;

    public EkoCommentFlagDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertAdapterOfEkoCommentFlagEntity = new EntityInsertAdapter<EkoCommentFlagEntity>(){

            @NonNull
            protected String createQuery() {
                return "INSERT OR REPLACE INTO `comment_flag` (`commentId`,`flag`,`localFlag`,`createdAt`,`updatedAt`,`expiresAt`) VALUES (?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull EkoCommentFlagEntity entity) {
                if (entity.getCommentId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getCommentId());
                }
                String _tmp = EkoCommentFlagDao_Impl.this.__ekoFlagTypeConverter.ekoFlagToString(entity.getFlag());
                if (_tmp == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindText(2, _tmp);
                }
                String _tmp_1 = EkoCommentFlagDao_Impl.this.__ekoLocalFlagTypeConverter.ekoLocalFlagToString(entity.getLocalFlag());
                if (_tmp_1 == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindText(3, _tmp_1);
                }
                String _tmp_2 = EkoCommentFlagDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp_2 == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindText(4, _tmp_2);
                }
                String _tmp_3 = EkoCommentFlagDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_3 == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, _tmp_3);
                }
                String _tmp_4 = EkoCommentFlagDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_4 == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindText(6, _tmp_4);
                }
            }
        };
        this.__deleteAdapterOfEkoCommentFlagEntity = new EntityDeleteOrUpdateAdapter<EkoCommentFlagEntity>(){

            @NonNull
            protected String createQuery() {
                return "DELETE FROM `comment_flag` WHERE `commentId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull EkoCommentFlagEntity entity) {
                if (entity.getCommentId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getCommentId());
                }
            }
        };
        this.__updateAdapterOfEkoCommentFlagEntity = new EntityDeleteOrUpdateAdapter<EkoCommentFlagEntity>(){

            @NonNull
            protected String createQuery() {
                return "UPDATE OR ABORT `comment_flag` SET `commentId` = ?,`flag` = ?,`localFlag` = ?,`createdAt` = ?,`updatedAt` = ?,`expiresAt` = ? WHERE `commentId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull EkoCommentFlagEntity entity) {
                if (entity.getCommentId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getCommentId());
                }
                String _tmp = EkoCommentFlagDao_Impl.this.__ekoFlagTypeConverter.ekoFlagToString(entity.getFlag());
                if (_tmp == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindText(2, _tmp);
                }
                String _tmp_1 = EkoCommentFlagDao_Impl.this.__ekoLocalFlagTypeConverter.ekoLocalFlagToString(entity.getLocalFlag());
                if (_tmp_1 == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindText(3, _tmp_1);
                }
                String _tmp_2 = EkoCommentFlagDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp_2 == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindText(4, _tmp_2);
                }
                String _tmp_3 = EkoCommentFlagDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_3 == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, _tmp_3);
                }
                String _tmp_4 = EkoCommentFlagDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_4 == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindText(6, _tmp_4);
                }
                if (entity.getCommentId() == null) {
                    statement.bindNull(7);
                } else {
                    statement.bindText(7, entity.getCommentId());
                }
            }
        };
    }

    @Override
    public void insertImpl(EkoCommentFlagEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfEkoCommentFlagEntity.insert(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insertImpl(List<? extends EkoCommentFlagEntity> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfEkoCommentFlagEntity.insert(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void delete(EkoCommentFlagEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfEkoCommentFlagEntity.handle(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void delete(List<? extends EkoCommentFlagEntity> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfEkoCommentFlagEntity.handleMultiple(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void updateImpl(EkoCommentFlagEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__updateAdapterOfEkoCommentFlagEntity.handle(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insert(EkoCommentFlagEntity object) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            EkoCommentFlagDao_Impl.super.insert(object);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void insert(List<? extends EkoCommentFlagEntity> objects) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            EkoCommentFlagDao_Impl.super.insert(objects);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void update(EkoCommentFlagEntity object) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            EkoCommentFlagDao_Impl.super.update(object);
            return Unit.INSTANCE;
        });
    }

    @Override
    EkoCommentFlagEntity getByIdNowImpl(String commentId) {
        String _sql = "SELECT * from comment_flag where commentId = ? LIMIT 1";
        return (EkoCommentFlagEntity)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from comment_flag where commentId = ? LIMIT 1");){
                EkoCommentFlagEntity _result;
                int _argIndex = 1;
                if (commentId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, commentId);
                }
                int _columnIndexOfCommentId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"commentId");
                int _columnIndexOfFlag = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"flag");
                int _columnIndexOfLocalFlag = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"localFlag");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    String _tmpCommentId = _stmt.isNull(_columnIndexOfCommentId) ? null : _stmt.getText(_columnIndexOfCommentId);
                    String _tmp = _stmt.isNull(_columnIndexOfFlag) ? null : _stmt.getText(_columnIndexOfFlag);
                    EkoFlag _tmpFlag = this.__ekoFlagTypeConverter.stringToEkoFlag(_tmp);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfLocalFlag) ? null : _stmt.getText(_columnIndexOfLocalFlag);
                    EkoLocalFlag _tmpLocalFlag = this.__ekoLocalFlagTypeConverter.stringToEkoLocalFlag(_tmp_1);
                    _result = new EkoCommentFlagEntity(_tmpCommentId, _tmpFlag, _tmpLocalFlag);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                EkoCommentFlagEntity ekoCommentFlagEntity = _result;
                return ekoCommentFlagEntity;
            }
        });
    }

    @Override
    Flowable<EkoCommentFlagEntity> getByCommentIdImpl(String commentId) {
        String _sql = "SELECT * from comment_flag where comment_flag.commentId = ? LIMIT 1";
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"comment_flag"}, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from comment_flag where comment_flag.commentId = ? LIMIT 1");){
                EkoCommentFlagEntity _result;
                int _argIndex = 1;
                if (commentId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, commentId);
                }
                int _columnIndexOfCommentId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"commentId");
                int _columnIndexOfFlag = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"flag");
                int _columnIndexOfLocalFlag = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"localFlag");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    String _tmpCommentId = _stmt.isNull(_columnIndexOfCommentId) ? null : _stmt.getText(_columnIndexOfCommentId);
                    String _tmp = _stmt.isNull(_columnIndexOfFlag) ? null : _stmt.getText(_columnIndexOfFlag);
                    EkoFlag _tmpFlag = this.__ekoFlagTypeConverter.stringToEkoFlag(_tmp);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfLocalFlag) ? null : _stmt.getText(_columnIndexOfLocalFlag);
                    EkoLocalFlag _tmpLocalFlag = this.__ekoLocalFlagTypeConverter.stringToEkoLocalFlag(_tmp_1);
                    _result = new EkoCommentFlagEntity(_tmpCommentId, _tmpFlag, _tmpLocalFlag);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                EkoCommentFlagEntity ekoCommentFlagEntity = _result;
                return ekoCommentFlagEntity;
            }
        });
    }

    @Override
    public void deleteAll() {
        String _sql = "DELETE from comment_flag";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("DELETE from comment_flag");){
                _stmt.step();
                Object var2_2 = null;
                return var2_2;
            }
        });
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

