/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.room.Dao;
import androidx.room.Query;
import androidx.room.Transaction;
import com.amity.socialcloud.sdk.model.core.role.AmityRoles;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.dao.AmityPagingDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoChannelPermissionDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoChannelRoleDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoObjectDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoPermissionDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoRoleDao;
import com.ekoapp.ekosdk.internal.data.model.ChannelMembershipPermissionEntity;
import com.ekoapp.ekosdk.internal.data.model.ChannelMembershipRoleEntity;
import com.ekoapp.ekosdk.internal.entity.ChannelMembershipEntity;
import io.reactivex.rxjava3.core.Flowable;
import java.util.List;
import org.joda.time.DateTime;

@Dao
public abstract class EkoChannelMembershipDao
extends EkoObjectDao<ChannelMembershipEntity>
implements AmityPagingDao<ChannelMembershipEntity> {
    private final EkoChannelRoleDao channelRoleDao;
    private final EkoChannelPermissionDao channelPermissionDao;

    EkoChannelMembershipDao() {
        UserDatabase db = UserDatabase.get();
        this.channelRoleDao = db.channelRoleDao();
        this.channelPermissionDao = db.channelPermissionDao();
    }

    @Override
    @Query(value="SELECT * from channel_membership where id = :id LIMIT 1")
    @Nullable
    public abstract ChannelMembershipEntity getByIdNow(@NonNull String var1);

    @Override
    @Query(value="SELECT * from channel_membership where id IN (:ids) LIMIT 1")
    @NonNull
    public abstract List<ChannelMembershipEntity> getByIdsNow(@NonNull List<String> var1);

    @Query(value="UPDATE channel_membership set membership = :membership, isBanned = 1 where channelId = :channelId and userId = :userId")
    public abstract void updateMembership(String var1, String var2, String var3);

    @Query(value="UPDATE channel_membership set readToSegment = :readToSegment where channelId = :channelId and userId = :userId and readToSegment < :readToSegment")
    public abstract void updateReadToSegment(String var1, String var2, int var3);

    @Query(value="UPDATE channel_membership set lastMentionedSegment = :lastMentionedSegment where channelId = :channelId and userId = :userId and lastMentionedSegment < :lastMentionedSegment")
    public abstract void updateLastMentionedSegment(String var1, String var2, int var3);

    @Query(value="UPDATE channel_membership set isMuted = :isMuted where channelId = :channelId and userId = :userId")
    public abstract void updateMemberIsMuted(String var1, String var2, boolean var3);

    @Override
    @Query(value="DELETE from channel_membership")
    public abstract void deleteAll();

    @Query(value="DELETE from channel_membership where channelId = :channelId")
    public abstract void deleteAllFromChannel(String var1);

    @Query(value="SELECT * from channel_membership where channelId = :channelId and userId = :userId LIMIT 1")
    abstract Flowable<ChannelMembershipEntity> getByChannelIdAndUserIdImpl(String var1, String var2);

    public Flowable<ChannelMembershipEntity> getByChannelIdAndUserId(String channelId, String userId) {
        return this.getByChannelIdAndUserIdImpl(channelId, userId);
    }

    @Query(value="SELECT * from channel_membership where channelId = :channelId")
    abstract Flowable<List<ChannelMembershipEntity>> getByChannelIdImpl(String var1);

    public Flowable<List<ChannelMembershipEntity>> getByChannelId(String channelId) {
        return this.getByChannelIdImpl(channelId);
    }

    @Query(value="SELECT * from channel_membership where channelId = :channelId and userId = :userId LIMIT 1")
    public abstract ChannelMembershipEntity getByChannelIdAndUserIdNow(String var1, String var2);

    @Query(value="SELECT * from channel_membership where channelId = :channelId")
    public abstract List<ChannelMembershipEntity> getByChannelIdNow(String var1);

    @Query(value="SELECT * from channel_membership where channel_membership.channelId = :channelId and channel_membership.membership in (:memberships) and case when :isFilterMuted then channel_membership.isMuted = :isMuted else isMuted is not null end and case when :isFilterByRoles then channel_membership.userId in (SELECT userId from channel_role where channelId = :channelId and roleName in (:roles)) else userId is not null end and channel_membership.updatedAt > :now and channel_membership.userId not in (SELECT amity_paging_id.id from amity_paging_id where amity_paging_id.hash = (:hash) and amity_paging_id.nonce = (:nonce) ) order by channel_membership.updatedAt  desc limit 1")
    abstract Flowable<ChannelMembershipEntity> getLatestChannelMembershipImpl(String var1, String[] var2, Boolean var3, Boolean var4, Boolean var5, String[] var6, int var7, int var8, DateTime var9);

    public Flowable<ChannelMembershipEntity> getLatestChannelMembership(String channelId, List<String> memberships, Boolean isMuted, AmityRoles roles, int hash, int nonce, DateTime now) {
        return this.getLatestChannelMembershipImpl(channelId, memberships.toArray(new String[0]), isMuted != null, isMuted, !roles.get().isEmpty(), roles.get().toArray(new String[0]), hash, nonce, now);
    }

    @Override
    @Transaction
    public void insert(ChannelMembershipEntity membership) {
        super.insert(membership);
        EkoRoleDao.update(membership, this.channelRoleDao, ChannelMembershipRoleEntity::create);
        EkoPermissionDao.update(membership, this.channelPermissionDao, ChannelMembershipPermissionEntity::create);
    }

    @Override
    @Transaction
    public void insert(List<? extends ChannelMembershipEntity> memberships) {
        super.insert(memberships);
        EkoRoleDao.update(memberships, this.channelRoleDao, ChannelMembershipRoleEntity::create);
        EkoPermissionDao.update(memberships, this.channelPermissionDao, ChannelMembershipPermissionEntity::create);
    }

    @Override
    public void update(ChannelMembershipEntity membership) {
        super.update(membership);
        EkoRoleDao.update(membership, this.channelRoleDao, ChannelMembershipRoleEntity::create);
        EkoPermissionDao.update(membership, this.channelPermissionDao, ChannelMembershipPermissionEntity::create);
    }

    @Transaction
    public void updateUser(String userId) {
        this.updateUserImpl(userId);
    }

    @Query(value="UPDATE channel_membership set userId = :userId where userId = :userId")
    abstract void updateUserImpl(String var1);
}

