/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.api;

import android.os.Build;
import com.amity.socialcloud.sdk.api.core.endpoint.AmityEndpoint;
import com.ekoapp.ekosdk.internal.api.EkoEndpoint;
import com.ekoapp.ekosdk.internal.data.EkoDatabase;
import com.ekoapp.ekosdk.internal.data.model.AmityUploadUrl;
import com.ekoapp.ekosdk.internal.data.model.EkoHttpUrl;
import com.ekoapp.ekosdk.internal.data.model.EkoMqttUrl;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.functions.Function;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\b\u001a\u00020\u0005J\u000e\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005J\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\fJ\u0006\u0010\r\u001a\u00020\u0005J\u0006\u0010\u000e\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/ekoapp/ekosdk/internal/api/EkoEndpoint;", "", "<init>", "()V", "httpUrl", "", "mqttUrl", "uploadUrl", "getHttpUrl", "mapHttpUrlByDeviceVersion", "url", "observeHttpUrl", "Lio/reactivex/rxjava3/core/Flowable;", "getMqttUrl", "getUploadUrl", "amity-sdk_release"})
public final class EkoEndpoint {
    @NotNull
    public static final EkoEndpoint INSTANCE = new EkoEndpoint();
    @NotNull
    private static String httpUrl = "";
    @NotNull
    private static String mqttUrl = "";
    @NotNull
    private static String uploadUrl = "";

    private EkoEndpoint() {
    }

    @NotNull
    public final String getHttpUrl() {
        String string = ((EkoHttpUrl)EkoDatabase.get().httpUrlDao().getCurrentHttpUrl().defaultIfEmpty((Object)EkoHttpUrl.create(AmityEndpoint.SG.INSTANCE.getHttpEndpoint())).blockingGet()).getHttpUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHttpUrl(...)");
        String storedUrl = string;
        if (!Intrinsics.areEqual((Object)storedUrl, (Object)httpUrl)) {
            httpUrl = this.mapHttpUrlByDeviceVersion(storedUrl);
        }
        return httpUrl;
    }

    @NotNull
    public final String mapHttpUrlByDeviceVersion(@NotNull String url) {
        String string;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return Build.VERSION.SDK_INT >= 26 ? url : (Intrinsics.areEqual((Object)(string = url), (Object)AmityEndpoint.SG.INSTANCE.getHttpEndpoint()) ? "https://api.sg.amity.co/" : (Intrinsics.areEqual((Object)string, (Object)AmityEndpoint.EU.INSTANCE.getHttpEndpoint()) ? "https://api.eu.amity.co/" : (Intrinsics.areEqual((Object)string, (Object)AmityEndpoint.US.INSTANCE.getHttpEndpoint()) ? "https://api.us.amity.co/" : (Intrinsics.areEqual((Object)string, (Object)"https://true-apix.amity.co") ? "https://true-api.amity.co" : url))));
    }

    @NotNull
    public final Flowable<String> observeHttpUrl() {
        Flowable flowable = EkoDatabase.get().httpUrlDao().observeCurrentHttpUrl().map((Function)observeHttpUrl.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"map(...)");
        return flowable;
    }

    @NotNull
    public final String getMqttUrl() {
        String string = ((EkoMqttUrl)EkoDatabase.get().mqttUrlDao().getCurrentMqttUrl().defaultIfEmpty((Object)EkoMqttUrl.create(AmityEndpoint.SG.INSTANCE.getMqttEndpoint())).blockingGet()).getMqttUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getMqttUrl(...)");
        String storedUrl = string;
        if (!Intrinsics.areEqual((Object)storedUrl, (Object)mqttUrl)) {
            mqttUrl = storedUrl;
        }
        return mqttUrl;
    }

    @NotNull
    public final String getUploadUrl() {
        String storedUrl = ((AmityUploadUrl)EkoDatabase.get().uploadUrlDao().getCurrentUploadUrl().defaultIfEmpty((Object)AmityUploadUrl.Companion.create(AmityEndpoint.SG.INSTANCE.getUploadEndpoint())).blockingGet()).getUploadUrl();
        if (!Intrinsics.areEqual((Object)storedUrl, (Object)uploadUrl)) {
            uploadUrl = storedUrl;
        }
        return uploadUrl;
    }
}

