/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.social.data.community;

import androidx.paging.PagingSource;
import com.amity.socialcloud.sdk.api.social.community.query.AmityCommunitySortOption;
import com.amity.socialcloud.sdk.entity.comunity.JoinRequestEntity;
import com.amity.socialcloud.sdk.model.social.community.AmityJoinRequestStatus;
import com.amity.socialcloud.sdk.social.data.community.CommunityJoinRequestLocalDataStore;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\bJ\u0014\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\nJ\u001e\u0010\u000f\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012J\u0016\u0010\u0013\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\bJ>\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00060\u00152\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\b2\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\bJ \u0010\u001c\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\n0\u00052\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\b0\n\u00a8\u0006\u001e"}, d2={"Lcom/amity/socialcloud/sdk/social/data/community/CommunityJoinRequestLocalDataStore;", "", "<init>", "()V", "observe", "Lio/reactivex/rxjava3/core/Flowable;", "Lcom/amity/socialcloud/sdk/entity/comunity/JoinRequestEntity;", "joinRequestId", "", "getJoinRequestByTargetId", "", "targetId", "saveJoinRequest", "Lio/reactivex/rxjava3/core/Completable;", "items", "updateJoinRequest", "userId", "status", "Lcom/amity/socialcloud/sdk/model/social/community/AmityJoinRequestStatus;", "deleteJoinRequest", "getCommunityJoinRequestsPagingSource", "Landroidx/paging/PagingSource;", "", "communityId", "sortBy", "Lcom/amity/socialcloud/sdk/api/social/community/query/AmityCommunitySortOption;", "targetType", "type", "getJoinRequestList", "joinRequestIds", "amity-sdk_release"})
public final class CommunityJoinRequestLocalDataStore {
    @NotNull
    public final Flowable<JoinRequestEntity> observe(@NotNull String joinRequestId) {
        Intrinsics.checkNotNullParameter((Object)joinRequestId, (String)"joinRequestId");
        Flowable flowable = UserDatabase.get().communityJoinRequestDao().observeJoinRequest(joinRequestId).map((Function)observe.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"map(...)");
        return flowable;
    }

    @Nullable
    public final List<JoinRequestEntity> getJoinRequestByTargetId(@NotNull String targetId) {
        Intrinsics.checkNotNullParameter((Object)targetId, (String)"targetId");
        Ref.ObjectRef joinRequest2 = new Ref.ObjectRef();
        Completable.fromCallable(() -> CommunityJoinRequestLocalDataStore.getJoinRequestByTargetId$lambda$0(targetId, joinRequest2)).subscribeOn(Schedulers.io()).blockingAwait();
        return (List)joinRequest2.element;
    }

    @NotNull
    public final Completable saveJoinRequest(@NotNull List<? extends JoinRequestEntity> items) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        Completable completable = Completable.fromAction(() -> CommunityJoinRequestLocalDataStore.saveJoinRequest$lambda$1(items));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"fromAction(...)");
        return completable;
    }

    @NotNull
    public final Completable updateJoinRequest(@NotNull String targetId, @NotNull String userId, @NotNull AmityJoinRequestStatus status) {
        Intrinsics.checkNotNullParameter((Object)targetId, (String)"targetId");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
        Completable completable = Completable.fromAction(() -> CommunityJoinRequestLocalDataStore.updateJoinRequest$lambda$2(targetId, userId, status));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"fromAction(...)");
        return completable;
    }

    @NotNull
    public final Completable deleteJoinRequest(@NotNull String targetId, @NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)targetId, (String)"targetId");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Completable completable = Completable.fromAction(() -> CommunityJoinRequestLocalDataStore.deleteJoinRequest$lambda$3(targetId, userId));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"fromAction(...)");
        return completable;
    }

    @NotNull
    public final PagingSource<Integer, JoinRequestEntity> getCommunityJoinRequestsPagingSource(@NotNull String communityId, @NotNull String status, @Nullable AmityCommunitySortOption sortBy, @NotNull String targetType, @NotNull String type2) {
        Intrinsics.checkNotNullParameter((Object)communityId, (String)"communityId");
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        Intrinsics.checkNotNullParameter((Object)targetType, (String)"targetType");
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        return UserDatabase.get().communityJoinRequestPagingDao().queryCommunityJoinRequests(communityId, status, sortBy, targetType, type2);
    }

    public static /* synthetic */ PagingSource getCommunityJoinRequestsPagingSource$default(CommunityJoinRequestLocalDataStore communityJoinRequestLocalDataStore, String string, String string2, AmityCommunitySortOption amityCommunitySortOption, String string3, String string4, int n, Object object) {
        if ((n & 4) != 0) {
            amityCommunitySortOption = null;
        }
        return communityJoinRequestLocalDataStore.getCommunityJoinRequestsPagingSource(string, string2, amityCommunitySortOption, string3, string4);
    }

    @NotNull
    public final Flowable<List<JoinRequestEntity>> getJoinRequestList(@NotNull List<String> joinRequestIds) {
        Intrinsics.checkNotNullParameter(joinRequestIds, (String)"joinRequestIds");
        return UserDatabase.get().communityJoinRequestDao().observeByJoinRequestIds(joinRequestIds);
    }

    private static final Unit getJoinRequestByTargetId$lambda$0(String $targetId, Ref.ObjectRef $joinRequest) {
        List<JoinRequestEntity> entity = UserDatabase.get().communityJoinRequestDao().getJoinRequestsByTargetId($targetId);
        if (!((Collection)entity).isEmpty()) {
            $joinRequest.element = entity;
        }
        return Unit.INSTANCE;
    }

    private static final void saveJoinRequest$lambda$1(List $items) {
        UserDatabase.get().communityJoinRequestDao().save($items);
    }

    private static final void updateJoinRequest$lambda$2(String $targetId, String $userId, AmityJoinRequestStatus $status) {
        UserDatabase.get().communityJoinRequestDao().updateJoinRequestByTargetIdAndUserId($targetId, $userId, $status.getStatus());
    }

    private static final void deleteJoinRequest$lambda$3(String $targetId, String $userId) {
        UserDatabase.get().communityJoinRequestDao().deleteJoinRequestByCommunityIdAndUserId($targetId, $userId);
    }
}

