package com.ekoapp.ekosdk.internal.data.converter

import androidx.room.TypeConverter
import com.ekoapp.ekosdk.internal.data.converter.EkoGson.get
import com.google.common.base.Strings
import com.google.gson.JsonObject

class JsonObjectTypeConverter {
	@TypeConverter
	fun stringToJsonObject(json: String?): JsonObject {
		return if (Strings.isNullOrEmpty(json)) {
			JsonObject()
		} else get().fromJson(json, JsonObject::class.java)
	}
	
	@TypeConverter
	fun jsonObjectToString(jsonObject: JsonObject?): String? {
		return if (jsonObject == null) {
			null
		} else get().toJson(jsonObject)
	}
}