package com.amity.socialcloud.sdk.social.data.event

import com.amity.socialcloud.sdk.core.data.file.FileEntityMapper
import com.amity.socialcloud.sdk.core.data.file.FileLocalDataStore
import com.amity.socialcloud.sdk.social.data.community.CommunityEntityMapper
import com.amity.socialcloud.sdk.social.data.community.CommunityLocalDataStore
import com.ekoapp.ekosdk.internal.api.dto.EventListDto
import io.reactivex.rxjava3.core.Completable

internal class EventQueryPersister {

    fun persist(dto: EventListDto): Completable {
        return Completable.defer {
            val fileCompletable = if (dto.files.isNotEmpty()) {
                FileLocalDataStore().saveFiles(FileEntityMapper().map(dto.files))
            } else {
                Completable.complete()
            }
            
            val eventCompletable = dto.events?.let { events ->
                val entities = EventEntityMapper().map(events)
                EventLocalDataStore().saveEvents(entities)
            } ?: Completable.complete()
            
            val communityCompletable = if (dto.communities.isNotEmpty()) {
                val communityEntities = CommunityEntityMapper().map(dto.communities)
                CommunityLocalDataStore().saveCommunities(communityEntities)
            } else {
                Completable.complete()
            }
            
            val discussionCommunityCompletable = if (dto.discussionCommunities.isNotEmpty()) {
                val discussionCommunityEntities = CommunityEntityMapper().map(dto.discussionCommunities)
                CommunityLocalDataStore().saveCommunities(discussionCommunityEntities)
            } else {
                Completable.complete()
            }
            
            Completable.mergeArray(
                fileCompletable,
                eventCompletable,
                communityCompletable,
                discussionCommunityCompletable
            )
        }
    }
}
