import android.os.Parcelable
import kotlinx.parcelize.Parcelize

@Parcelize
data class AmityPII(
    val offset: Int,
    val length: Int,
    val confidence: Double,
    val category: Category
) : Parcelable {

    sealed class Category : Parcelable {
        @Parcelize
        object EMAIL : Category()

        @Parcelize
        object PHONE_NUMBER : Category()

        @Parcelize
        object IP_ADDRESS : Category()

        @Parcelize
        object ADDRESS : Category()

        @Parcelize
        object PASSPORT_NUMBER : Category()


        @Parcelize
        class OTHERS(val value: String) : Category()

        companion object {
            fun values(): List<Category> {
                return listOf(EMAIL, PHONE_NUMBER, IP_ADDRESS, ADDRESS, PASSPORT_NUMBER)
            }
        }
    }

    companion object {
        /**
         * Default character used for PII redaction
         */
        const val DEFAULT_REDACTION_CHAR = '*'

        /**
         * Creates a new AmityPII instance
         */
        fun create(
            offset: Int,
            length: Int,
            confidence: Double,
            category: Category
        ): AmityPII {
            return AmityPII(offset, length, confidence, category)
        }
    }
}