package com.amity.socialcloud.sdk.core.data.user

import com.amity.socialcloud.sdk.model.core.user.UserUpdateOption
import com.ekoapp.ekosdk.internal.api.AmityHttpClient
import com.ekoapp.ekosdk.internal.api.dto.EkoUserListDto
import com.ekoapp.ekosdk.internal.api.socket.request.UserUpdateRequest
import com.google.gson.JsonObject
import io.reactivex.rxjava3.core.Single

internal class UserRemoteDataStore {

    fun updateUser(userId: String, option: UserUpdateOption): Single<EkoUserListDto> {
        val request = UserUpdateRequest(
            userId = userId,
            displayName = option.displayName,
            roles = option.roles,
            metadata = option.metadata,
            avatarFileId = option.avatarFileId,
            avatarCustomUrl = option.avatarCustomUrl,
            description = option.description
        )
        return AmityHttpClient.get(UserApi::class).flatMap {
            it.updateUser(request)
        }
    }

    fun getUsers(
        keyword: String?,
        matchType: String?,
        sortBy: String?,
        limit: Int?,
        token: String?
    ): Single<EkoUserListDto> {
        return AmityHttpClient.get(UserApi::class).flatMap {
            it.queryUsers(
                keyword = keyword ?: "",
                matchType = matchType,
                sortBy = sortBy,
                limit = limit,
                token = token
            )
        }
    }

    fun getUser(userId: String): Single<EkoUserListDto> {
        return AmityHttpClient.get(UserApi::class).flatMap {
            it.getUser(userId)
        }
    }

    fun getUserByIds(userIds: List<String>) : Single<EkoUserListDto> {
        return AmityHttpClient.get(UserApi::class).flatMap {
            it.getUserByIds(userIds)
        }
    }

    fun flagUser(userId: String): Single<EkoUserListDto> {
        return AmityHttpClient.get(UserApi::class).flatMap {
            it.flagUser(userId)
        }
    }

    fun unflagUser(userId: String): Single<EkoUserListDto> {
        return AmityHttpClient.get(UserApi::class).flatMap {
            it.unflagUser(userId)
        }
    }

    fun isFlaggedByMe(userId: String): Single<JsonObject> {
        return AmityHttpClient.get(UserApi::class).flatMap {
            it.isFlaggedByMe(userId)
        }
    }
}

