package com.amity.socialcloud.sdk.core.data.settings.network.core.user

import com.amity.socialcloud.sdk.common.QueryPersister
import com.amity.socialcloud.sdk.core.data.settings.network.NetworkSettingsLocalDataStore
import io.reactivex.rxjava3.core.Completable


internal class UserSettingsQueryPersister : QueryPersister<UserSettingsDto>() {

    override fun persist(dto: UserSettingsDto): Completable {
        return NetworkSettingsLocalDataStore().saveUserSettings(
            UserSettingsEntityMapper().map(listOf(dto))
        )
    }
}