package com.amity.socialcloud.sdk.api.core.invitation

import androidx.paging.PagingData
import com.amity.socialcloud.sdk.core.data.reaction.paging.InvitationMediator
import com.amity.socialcloud.sdk.model.core.invitation.AmityInvitation
import com.amity.socialcloud.sdk.model.core.invitation.AmityInvitationType
import com.ekoapp.ekosdk.internal.usecase.invitation.InvitationPagingDataUseCase
import io.reactivex.rxjava3.core.Flowable

class AmityInvitationRepository internal constructor() {

    fun getMyCommunityInvitations(): Flowable<PagingData<AmityInvitation>> {
        return InvitationPagingDataUseCase().execute(
            type = AmityInvitationType.COMMUNITY_MEMBER,
            target = InvitationMediator.Target.ME
        )
    }

}