package com.amity.socialcloud.sdk.api.chat.member.search

import androidx.paging.PagingData
import com.amity.socialcloud.sdk.api.chat.member.query.AmityChannelMembership
import com.amity.socialcloud.sdk.model.chat.member.AmityChannelMember
import com.amity.socialcloud.sdk.model.core.role.AmityRoles
import com.amity.socialcloud.sdk.chat.domain.channel.member.SearchChannelMembershipPagingSourceUseCase
import io.reactivex.rxjava3.core.Flowable

class AmityChannelMemberSearch internal constructor(
    private val channelId: String,
    private val roles: AmityRoles,
    private val memberships: List<AmityChannelMembership>,
    private val keyword: String,
    private val isDeleted: Boolean?
) {

    fun query(): Flowable<PagingData<AmityChannelMember>> {
        return SearchChannelMembershipPagingSourceUseCase().execute(
            channelId,
            memberships,
            roles,
            keyword,
            isDeleted
        )
    }

    class Builder internal constructor(
        private var channelId: String,
        private var keyword: String,
        private var isDeleted: Boolean? = null // current BE default value
    ) {

        private var roles = AmityRoles()

        // current BE default value
        private var memberships = listOf(AmityChannelMembership.MEMBER)

        fun membershipFilter(channelMembership: List<AmityChannelMembership>): Builder {
            return apply {
                if(channelMembership.isNotEmpty()) {
                    this.memberships = channelMembership
                }
            }
        }

        fun roles(roles: List<String>): Builder {
            return apply {
                this.roles = AmityRoles(roles)
            }
        }

        fun includeDeleted(includeDeleted: Boolean): Builder {
            return apply {
                this.isDeleted = if(includeDeleted) null else false
            }
        }

        fun build(): AmityChannelMemberSearch {
            return AmityChannelMemberSearch(channelId, roles, memberships, keyword, isDeleted)
        }
    }

}