package com.amity.socialcloud.sdk.api.chat.member.query

import androidx.paging.PagingData
import com.amity.socialcloud.sdk.model.chat.member.AmityChannelMember
import com.amity.socialcloud.sdk.model.core.role.AmityRoles
import com.amity.socialcloud.sdk.chat.domain.channel.member.GetChannelMembershipPagingSourceUseCase
import io.reactivex.rxjava3.core.Flowable

class AmityChannelMembershipQuery internal constructor(
    private val channelId: String,
    private val filter: AmityChannelMembershipFilter,
    private val roles: AmityRoles,
    private val isDeleted: Boolean?,
    private val sortOption: AmityChannelMembershipSortOption
) {

    fun query(): Flowable<PagingData<AmityChannelMember>> {
        return GetChannelMembershipPagingSourceUseCase().execute(
            channelId = channelId,
            filter = filter,
            roles = roles,
            sortOption = sortOption,
            isDeleted = isDeleted
        )
    }

    class Builder internal constructor(private val channelId: String) {

        private var isDeleted: Boolean? = null
        private var roles = AmityRoles()
        private var filter: AmityChannelMembershipFilter = AmityChannelMembershipFilter.ALL
        private var sortOption: AmityChannelMembershipSortOption =
            AmityChannelMembershipSortOption.LAST_CREATED

        fun filter(filter: AmityChannelMembershipFilter): Builder {
            return apply {
                this.filter = filter
            }
        }

        fun roles(roles: List<String>): Builder {
            return apply {
                this.roles = AmityRoles(roles)
            }
        }

        fun sortBy(sortOption: AmityChannelMembershipSortOption): Builder {
            return apply { this.sortOption = sortOption }
        }

        fun includeDeleted(includeDeleted: Boolean): Builder {
            return apply {
                this.isDeleted = if (includeDeleted) null else false
            }
        }

        fun build(): AmityChannelMembershipQuery {
            return AmityChannelMembershipQuery(
                channelId = channelId,
                filter = filter,
                roles = roles,
                sortOption = sortOption,
                isDeleted = isDeleted
            )
        }
    }

}